/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;

final class LocalizedTextConversions {
    private LocalizedTextConversions() {
    }

    @Nullable
    static String localizedTextToString(@Nonnull LocalizedText text) {
        return text.getText();
    }

    @Nullable
    static Object convert(@Nonnull Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof LocalizedText) {
            LocalizedText text = (LocalizedText)o;
            return implicit ? LocalizedTextConversions.implicitConversion(text, targetType) : LocalizedTextConversions.explicitConversion(text, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@Nonnull LocalizedText text, BuiltinDataType targetType) {
        return LocalizedTextConversions.implicitConversion(text, targetType);
    }

    @Nullable
    static Object implicitConversion(@Nonnull LocalizedText text, BuiltinDataType targetType) {
        switch (targetType) {
            case String: {
                return LocalizedTextConversions.localizedTextToString(text);
            }
        }
        return null;
    }
}

