/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.operators;

import java.lang.reflect.Array;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.server.events.FilterContext;
import org.eclipse.milo.opcua.sdk.server.events.OperatorContext;
import org.eclipse.milo.opcua.sdk.server.events.ValidationException;
import org.eclipse.milo.opcua.sdk.server.events.conversions.ImplicitConversions;
import org.eclipse.milo.opcua.sdk.server.events.operators.Operator;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.BaseEventTypeNode;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.structured.FilterOperand;
import org.eclipse.milo.opcua.stack.core.util.ArrayUtil;

abstract class ImplicitConversionBinaryOperator<T>
implements Operator<T> {
    ImplicitConversionBinaryOperator() {
    }

    @Override
    public void validate(FilterContext context, FilterOperand[] operands) throws ValidationException {
        if (operands.length < 2) {
            throw new ValidationException(2160263168L);
        }
    }

    @Override
    @Nullable
    public T apply(OperatorContext context, BaseEventTypeNode eventNode, FilterOperand[] operands) throws UaException {
        int p1;
        this.validate(context, operands);
        FilterOperand op0 = operands[0];
        FilterOperand op1 = operands[1];
        Object value0 = context.resolve(op0, eventNode);
        Object value1 = context.resolve(op1, eventNode);
        if (value0 == null || value1 == null) {
            return null;
        }
        BuiltinDataType dt0 = ImplicitConversionBinaryOperator.getType(value0);
        BuiltinDataType dt1 = ImplicitConversionBinaryOperator.getType(value1);
        if (dt0 == null || dt1 == null) {
            throw new UaException(0x80010000L);
        }
        int p0 = ImplicitConversions.getPrecedence(dt0);
        if (p0 == (p1 = ImplicitConversions.getPrecedence(dt1))) {
            assert (dt0 == dt1);
            return this.apply(context, eventNode, dt0, value0, value1);
        }
        if (p0 >= p1) {
            Object converted1 = ImplicitConversionBinaryOperator.convert(value1, dt0);
            return this.apply(context, eventNode, dt0, value0, converted1);
        }
        Object converted0 = ImplicitConversionBinaryOperator.convert(value0, dt1);
        return this.apply(context, eventNode, dt1, converted0, value1);
    }

    @Nullable
    protected abstract T apply(OperatorContext var1, BaseEventTypeNode var2, BuiltinDataType var3, @Nullable Object var4, @Nullable Object var5) throws UaException;

    @Nullable
    private static Object convert(@Nonnull Object value, BuiltinDataType targetType) {
        if (value.getClass().isArray()) {
            return ImplicitConversionBinaryOperator.convertArray(value, targetType);
        }
        return ImplicitConversions.convert(value, targetType);
    }

    private static Object convertArray(@Nonnull Object array, BuiltinDataType targetType) {
        int[] dimensions = ArrayUtil.getDimensions((Object)array);
        Object flattened = ArrayUtil.flatten((Object)array);
        int length = Array.getLength(flattened);
        Object transformed = Array.newInstance(targetType.getBackingClass(), length);
        for (int i = 0; i < length; ++i) {
            Object sourceValue = Array.get(flattened, i);
            Object targetValue = ImplicitConversions.convert(sourceValue, targetType);
            Array.set(transformed, i, targetValue);
        }
        return ArrayUtil.unflatten((Object)transformed, (int[])dimensions);
    }

    private static BuiltinDataType getType(@Nonnull Object o) {
        if (o.getClass().isArray()) {
            return BuiltinDataType.fromBackingClass((Class)ArrayUtil.getType((Object)o));
        }
        return BuiltinDataType.fromBackingClass(o.getClass());
    }
}

