/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.identity;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.identity.AbstractIdentityValidator;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.structured.AnonymousIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.UserNameIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;

public abstract class AbstractUsernameIdentityValidator<T>
extends AbstractIdentityValidator<T> {
    @Override
    protected T validateAnonymousToken(Session session, AnonymousIdentityToken token, UserTokenPolicy tokenPolicy, SignatureData tokenSignature) throws UaException {
        return this.authenticateAnonymousOrThrow(session);
    }

    @Override
    protected T validateUsernameToken(Session session, UserNameIdentityToken token, UserTokenPolicy tokenPolicy, SignatureData tokenSignature) throws UaException {
        SecurityAlgorithm algorithm;
        String username = token.getUserName();
        ByteString lastNonce = session.getLastNonce();
        int lastNonceLength = lastNonce.length();
        if (username == null || username.isEmpty()) {
            throw new UaException(0x80200000L);
        }
        String algorithmUri = token.getEncryptionAlgorithm();
        if (algorithmUri == null || algorithmUri.isEmpty()) {
            SecurityPolicy securityPolicy = session.getSecurityConfiguration().getSecurityPolicy();
            algorithm = securityPolicy.getAsymmetricEncryptionAlgorithm();
        } else {
            try {
                algorithm = SecurityAlgorithm.fromUri((String)algorithmUri);
            }
            catch (UaException e) {
                throw new UaException(0x80200000L);
            }
            if (algorithm != SecurityAlgorithm.Rsa15 && algorithm != SecurityAlgorithm.RsaOaepSha1 && algorithm != SecurityAlgorithm.RsaOaepSha256) {
                throw new UaException(0x80200000L);
            }
        }
        byte[] tokenBytes = token.getPassword().bytesOrEmpty();
        if (algorithm != SecurityAlgorithm.None) {
            byte[] plainTextBytes = this.decryptTokenData(session, algorithm, tokenBytes);
            long length = ((long)plainTextBytes[3] & 0xFFL) << 24 | ((long)plainTextBytes[2] & 0xFFL) << 16 | ((long)plainTextBytes[1] & 0xFFL) << 8 | (long)plainTextBytes[0] & 0xFFL;
            if (length > (long)(plainTextBytes.length - 4)) {
                throw new UaException(0x80200000L, "invalid token data");
            }
            int passwordLength = (int)length - lastNonceLength;
            if (passwordLength < 0) {
                throw new UaException(0x80200000L, "invalid password length");
            }
            if ((long)passwordLength > session.getServer().getConfig().getLimits().getMaxPasswordLength().longValue()) {
                throw new UaException(0x80080000L, "password length exceeds limits");
            }
            byte[] passwordBytes = new byte[passwordLength];
            byte[] nonceBytes = new byte[lastNonceLength];
            System.arraycopy(plainTextBytes, 4, passwordBytes, 0, passwordBytes.length);
            System.arraycopy(plainTextBytes, 4 + passwordBytes.length, nonceBytes, 0, lastNonceLength);
            if (MessageDigest.isEqual(lastNonce.bytes(), nonceBytes)) {
                String password = new String(passwordBytes, StandardCharsets.UTF_8);
                return this.authenticateUsernameOrThrow(session, username, password);
            }
            throw new UaException(2149515264L);
        }
        String password = new String(tokenBytes, StandardCharsets.UTF_8);
        return this.authenticateUsernameOrThrow(session, username, password);
    }

    private T authenticateAnonymousOrThrow(Session session) throws UaException {
        T identityObject = this.authenticateAnonymous(session);
        if (identityObject != null) {
            return identityObject;
        }
        throw new UaException(2149515264L);
    }

    private T authenticateUsernameOrThrow(Session session, String username, String password) throws UaException {
        T identityObject = this.authenticateUsernamePassword(session, username, password);
        if (identityObject != null) {
            return identityObject;
        }
        throw new UaException(2149515264L);
    }

    @Nullable
    protected abstract T authenticateAnonymous(Session var1);

    @Nullable
    protected abstract T authenticateUsernamePassword(Session var1, String var2, String var3);
}

