/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.sdk.server.ObjectTypeManager;
import org.eclipse.milo.opcua.sdk.server.VariableTypeManager;
import org.eclipse.milo.opcua.sdk.server.api.NodeManager;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ObjectTypeNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaObjectTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableTypeNode;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;

@Deprecated
public class NodeFactory {
    private final UaNodeContext context;
    private final ObjectTypeManager objectTypeManager;
    private final VariableTypeManager variableTypeManager;

    public NodeFactory(UaNodeContext context, ObjectTypeManager objectTypeManager, VariableTypeManager variableTypeManager) {
        this.context = context;
        this.objectTypeManager = objectTypeManager;
        this.variableTypeManager = variableTypeManager;
    }

    public UaObjectNode createObject(NodeId nodeId, QualifiedName browseName, LocalizedText displayName, NodeId typeDefinitionId) {
        UaObjectNode objectNode = (UaObjectNode)this.createNode(nodeId, typeDefinitionId);
        objectNode.setBrowseName(browseName);
        objectNode.setDisplayName(displayName);
        return objectNode;
    }

    public UaVariableNode createVariable(NodeId nodeId, QualifiedName browseName, LocalizedText displayName, NodeId typeDefinitionId) {
        UaVariableNode variableNode = (UaVariableNode)this.createNode(nodeId, typeDefinitionId);
        variableNode.setBrowseName(browseName);
        variableNode.setDisplayName(displayName);
        return variableNode;
    }

    private UaNode createNode(NodeId nodeId, NodeId typeDefinitionId) throws UaRuntimeException {
        UaNode node;
        NodeManager<UaNode> nodeManager = this.context.getNodeManager();
        NamespaceTable namespaceTable = this.context.getServer().getNamespaceTable();
        UaNode typeDefinitionNode = this.context.getServer().getAddressSpaceManager().getManagedNode(typeDefinitionId).orElseThrow(() -> new UaRuntimeException(2150891520L, "unknown type definition: " + typeDefinitionId));
        if (typeDefinitionNode instanceof VariableTypeNode) {
            node = this.instanceFromTypeDefinition(nodeId, (UaVariableTypeNode)typeDefinitionNode);
            nodeManager.addNode(node);
        } else if (typeDefinitionNode instanceof ObjectTypeNode) {
            node = this.instanceFromTypeDefinition(nodeId, (UaObjectTypeNode)typeDefinitionNode);
            nodeManager.addNode(node);
        } else {
            throw new UaRuntimeException(0x80010000L, "typeDefinitionNode: " + typeDefinitionNode);
        }
        List propertyDeclarations = typeDefinitionNode.getReferences().stream().filter(Reference.HAS_PROPERTY_PREDICATE).distinct().map(r -> nodeManager.getNode(r.getTargetNodeId(), namespaceTable)).flatMap(StreamUtil::opt2stream).map(UaVariableNode.class::cast).filter(vn -> vn.getReferences().stream().anyMatch(r -> Identifiers.HasModellingRule.equals((Object)r.getReferenceTypeId()) && Identifiers.ModellingRule_Mandatory.equals(r.getTargetNodeId()))).collect(Collectors.toList());
        for (Object declaration : propertyDeclarations) {
            UaVariableTypeNode typeDefinition = (UaVariableTypeNode)((UaVariableNode)declaration).getTypeDefinitionNode();
            NodeId instanceId = this.createNodeId(nodeId, ((UaNode)declaration).getBrowseName().getName());
            UaVariableNode instance = (UaVariableNode)this.createNode(instanceId, typeDefinition.getNodeId());
            instance.setBrowseName(((UaNode)declaration).getBrowseName());
            instance.setDisplayName(((UaNode)declaration).getDisplayName());
            instance.setDescription(((UaNode)declaration).getDescription());
            instance.setWriteMask(((UaNode)declaration).getWriteMask());
            instance.setUserWriteMask(((UaNode)declaration).getUserWriteMask());
            instance.setValue(((UaVariableNode)declaration).getValue());
            instance.setDataType(((UaVariableNode)declaration).getDataType());
            instance.setValueRank(((UaVariableNode)declaration).getValueRank());
            instance.setArrayDimensions(((UaVariableNode)declaration).getArrayDimensions());
            instance.setAccessLevel(((UaVariableNode)declaration).getAccessLevel());
            instance.setUserAccessLevel(((UaVariableNode)declaration).getUserAccessLevel());
            node.addProperty(instance);
            nodeManager.addNode(instance);
        }
        List variableComponents = typeDefinitionNode.getReferences().stream().filter(Reference.HAS_COMPONENT_PREDICATE).map(r -> nodeManager.getNode(r.getTargetNodeId(), namespaceTable)).flatMap(StreamUtil::opt2stream).filter(n -> n instanceof UaVariableNode).map(UaVariableNode.class::cast).collect(Collectors.toList());
        for (UaVariableNode declaration : variableComponents) {
            boolean placeholder = declaration.getReferences().stream().anyMatch(r -> r.isForward() && r.getReferenceTypeId().equals((Object)Identifiers.HasModellingRule) && (Identifiers.ModellingRule_OptionalPlaceholder.equals(r.getTargetNodeId()) || Identifiers.ModellingRule_MandatoryPlaceholder.equals(r.getTargetNodeId()) || Identifiers.ModellingRule_ExposesItsArray.equals(r.getTargetNodeId())));
            if (placeholder) continue;
            UaVariableTypeNode typeDefinition = (UaVariableTypeNode)declaration.getTypeDefinitionNode();
            NodeId instanceId = this.createNodeId(nodeId, declaration.getBrowseName().getName());
            UaVariableNode instance = (UaVariableNode)this.createNode(instanceId, typeDefinition.getNodeId());
            instance.setBrowseName(declaration.getBrowseName());
            instance.setDisplayName(declaration.getDisplayName());
            instance.setDescription(declaration.getDescription());
            instance.setWriteMask(declaration.getWriteMask());
            instance.setUserWriteMask(declaration.getUserWriteMask());
            instance.setValue(declaration.getValue());
            instance.setDataType(declaration.getDataType());
            instance.setValueRank(declaration.getValueRank());
            instance.setArrayDimensions(declaration.getArrayDimensions());
            instance.setAccessLevel(declaration.getAccessLevel());
            instance.setUserAccessLevel(declaration.getUserAccessLevel());
            this.addComponent(node, instance);
            nodeManager.addNode(instance);
        }
        if (node instanceof ObjectNode) {
            List objectComponents = typeDefinitionNode.getReferences().stream().filter(Reference.HAS_COMPONENT_PREDICATE).map(r -> nodeManager.getNode(r.getTargetNodeId(), namespaceTable)).flatMap(StreamUtil::opt2stream).filter(n -> n instanceof UaObjectNode).map(UaObjectNode.class::cast).collect(Collectors.toList());
            for (UaObjectNode declaration : objectComponents) {
                boolean placeholder = declaration.getReferences().stream().anyMatch(r -> r.isForward() && r.getReferenceTypeId().equals((Object)Identifiers.HasModellingRule) && (Identifiers.ModellingRule_OptionalPlaceholder.equals(r.getTargetNodeId()) || Identifiers.ModellingRule_MandatoryPlaceholder.equals(r.getTargetNodeId()) || Identifiers.ModellingRule_ExposesItsArray.equals(r.getTargetNodeId())));
                if (placeholder) continue;
                UaObjectTypeNode typeDefinition = (UaObjectTypeNode)declaration.getTypeDefinitionNode();
                NodeId instanceId = this.createNodeId(nodeId, declaration.getBrowseName().getName());
                UaObjectNode instance = (UaObjectNode)this.createNode(instanceId, typeDefinition.getNodeId());
                instance.setBrowseName(declaration.getBrowseName());
                instance.setDisplayName(declaration.getDisplayName());
                instance.setDescription(declaration.getDescription());
                instance.setWriteMask(declaration.getWriteMask());
                instance.setUserWriteMask(declaration.getUserWriteMask());
                instance.setEventNotifier(declaration.getEventNotifier());
                this.addComponent(node, instance);
                nodeManager.addNode(instance);
            }
        }
        return node;
    }

    private UaObjectNode instanceFromTypeDefinition(NodeId nodeId, ObjectTypeNode typeDefinitionNode) {
        NodeId typeDefinitionId = typeDefinitionNode.getNodeId();
        ObjectTypeManager.ObjectNodeConstructor ctor = this.objectTypeManager.getNodeFactory(typeDefinitionId).orElseThrow(() -> new UaRuntimeException(2153971712L, "no NodeFactory for type definition: " + typeDefinitionId));
        UaObjectNode objectNode = ctor.apply(this.context, nodeId, typeDefinitionNode.getBrowseName(), typeDefinitionNode.getDisplayName(), typeDefinitionNode.getDescription(), typeDefinitionNode.getWriteMask(), typeDefinitionNode.getUserWriteMask());
        objectNode.addReference(new Reference(objectNode.getNodeId(), Identifiers.HasTypeDefinition, typeDefinitionId.expanded(), true));
        return objectNode;
    }

    private UaVariableNode instanceFromTypeDefinition(NodeId nodeId, VariableTypeNode typeDefinitionNode) {
        NodeId typeDefinitionId = typeDefinitionNode.getNodeId();
        VariableTypeManager.VariableNodeConstructor ctor = this.variableTypeManager.getNodeFactory(typeDefinitionId).orElseThrow(() -> new UaRuntimeException(2153971712L, "no NodeFactory for type definition: " + typeDefinitionId));
        UaVariableNode variableNode = ctor.apply(this.context, nodeId, typeDefinitionNode.getBrowseName(), typeDefinitionNode.getDisplayName(), typeDefinitionNode.getDescription(), typeDefinitionNode.getWriteMask(), typeDefinitionNode.getUserWriteMask());
        variableNode.setValue(typeDefinitionNode.getValue());
        variableNode.setDataType(typeDefinitionNode.getDataType());
        variableNode.setValueRank(typeDefinitionNode.getValueRank());
        variableNode.setArrayDimensions(typeDefinitionNode.getArrayDimensions());
        variableNode.addReference(new Reference(variableNode.getNodeId(), Identifiers.HasTypeDefinition, typeDefinitionId.expanded(), true));
        return variableNode;
    }

    private void addComponent(UaNode sourceNode, UaNode targetNode) {
        sourceNode.addReference(new Reference(sourceNode.getNodeId(), Identifiers.HasComponent, targetNode.getNodeId().expanded(), true));
        targetNode.addReference(new Reference(targetNode.getNodeId(), Identifiers.HasComponent, sourceNode.getNodeId().expanded(), false));
    }

    private NodeId createNodeId(NodeId nodeId, String toAppend) {
        return new NodeId(nodeId.getNamespaceIndex(), nodeId.getIdentifier() + "." + toAppend);
    }
}

