/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes;

import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.core.nodes.DataTypeNodeProperties;
import org.eclipse.milo.opcua.sdk.server.api.nodes.DataTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.EnumValueType;

public class UaDataTypeNode
extends UaNode
implements DataTypeNode {
    private volatile Boolean isAbstract;

    public UaDataTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, boolean isAbstract) {
        super(context, nodeId, NodeClass.DataType, browseName, displayName, description, writeMask, userWriteMask);
        this.isAbstract = isAbstract;
    }

    @Override
    public Boolean getIsAbstract() {
        return this.isAbstract;
    }

    @Override
    public synchronized void setIsAbstract(Boolean isAbstract) {
        this.isAbstract = isAbstract;
        this.fireAttributeChanged(AttributeId.IsAbstract, isAbstract);
    }

    @Override
    public synchronized Object getAttribute(AttributeId attributeId) {
        switch (attributeId) {
            case IsAbstract: {
                return this.isAbstract;
            }
        }
        return super.getAttribute(attributeId);
    }

    @Override
    public synchronized void setAttribute(AttributeId attributeId, Object value) {
        switch (attributeId) {
            case IsAbstract: {
                this.isAbstract = (Boolean)value;
                break;
            }
            default: {
                super.setAttribute(attributeId, value);
                return;
            }
        }
        this.fireAttributeChanged(attributeId, value);
    }

    @Nullable
    public String getNodeVersion() {
        return this.getProperty(DataTypeNodeProperties.NodeVersion).orElse(null);
    }

    @Nullable
    public LocalizedText[] getEnumStrings() {
        return this.getProperty(DataTypeNodeProperties.EnumStrings).orElse(null);
    }

    @Nullable
    public EnumValueType[] getEnumValues() {
        return this.getProperty(DataTypeNodeProperties.EnumValues).orElse(null);
    }

    @Nullable
    public LocalizedText[] getOptionSetValues() {
        return this.getProperty(DataTypeNodeProperties.OptionSetValues).orElse(null);
    }

    public void setNodeVersion(String nodeVersion) {
        this.setProperty(DataTypeNodeProperties.NodeVersion, nodeVersion);
    }

    public void setEnumStrings(LocalizedText[] enumStrings) {
        this.setProperty(DataTypeNodeProperties.EnumStrings, enumStrings);
    }

    public void setEnumValues(EnumValueType[] enumValues) {
        this.setProperty(DataTypeNodeProperties.EnumValues, enumValues);
    }

    public void setOptionSetValues(LocalizedText[] optionSetValues) {
        this.setProperty(DataTypeNodeProperties.OptionSetValues, optionSetValues);
    }
}

