/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.nodes.ObjectTypeNodeProperties;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ObjectTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public class UaObjectTypeNode
extends UaNode
implements ObjectTypeNode {
    private Boolean isAbstract;

    public UaObjectTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, Boolean isAbstract) {
        super(context, nodeId, NodeClass.ObjectType, browseName, displayName, description, writeMask, userWriteMask);
        this.isAbstract = isAbstract;
    }

    @Override
    public Boolean getIsAbstract() {
        return this.isAbstract;
    }

    @Override
    public synchronized void setIsAbstract(Boolean isAbstract) {
        this.isAbstract = isAbstract;
        this.fireAttributeChanged(AttributeId.IsAbstract, isAbstract);
    }

    @Override
    public synchronized Object getAttribute(AttributeId attributeId) {
        switch (attributeId) {
            case IsAbstract: {
                return this.isAbstract;
            }
        }
        return super.getAttribute(attributeId);
    }

    @Override
    public synchronized void setAttribute(AttributeId attributeId, Object value) {
        switch (attributeId) {
            case IsAbstract: {
                this.isAbstract = (Boolean)value;
                break;
            }
            default: {
                super.setAttribute(attributeId, value);
                return;
            }
        }
        this.fireAttributeChanged(attributeId, value);
    }

    @Nullable
    public UaMethodNode findMethodNode(NodeId methodId) {
        return this.getReferences().stream().filter(Reference.HAS_COMPONENT_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getManagedNode(r.getTargetNodeId()))).filter(n -> n instanceof UaMethodNode && Objects.equals(n.getNodeId(), methodId)).map(UaMethodNode.class::cast).findFirst().orElse(null);
    }

    public List<UaMethodNode> getMethodNodes() {
        return this.getReferences().stream().filter(Reference.HAS_COMPONENT_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getManagedNode(r.getTargetNodeId()))).filter(n -> n instanceof UaMethodNode).map(UaMethodNode.class::cast).collect(Collectors.toList());
    }

    public void addComponent(UaNode node) {
        this.addReference(new Reference(this.getNodeId(), Identifiers.HasComponent, node.getNodeId().expanded(), true));
        node.addReference(new Reference(node.getNodeId(), Identifiers.HasComponent, this.getNodeId().expanded(), false));
    }

    public void addSubtype(UaObjectTypeNode node) {
        this.addReference(new Reference(this.getNodeId(), Identifiers.HasSubtype, node.getNodeId().expanded(), true));
        node.addReference(new Reference(node.getNodeId(), Identifiers.HasSubtype, this.getNodeId().expanded(), false));
    }

    @Nullable
    public String getNodeVersion() {
        return this.getProperty(ObjectTypeNodeProperties.NodeVersion).orElse(null);
    }

    @Nullable
    public ByteString getIcon() {
        return this.getProperty(ObjectTypeNodeProperties.Icon).orElse(null);
    }

    public void setNodeVersion(String nodeVersion) {
        this.setProperty(ObjectTypeNodeProperties.NodeVersion, nodeVersion);
    }

    public void setIcon(ByteString icon) {
        this.setProperty(ObjectTypeNodeProperties.Icon, icon);
    }

    public static UaObjectTypeNodeBuilder builder(UaNodeContext context) {
        return new UaObjectTypeNodeBuilder(context);
    }

    public static class UaObjectTypeNodeBuilder
    implements Supplier<UaObjectTypeNode> {
        private final List<Reference> references = Lists.newArrayList();
        private NodeId nodeId;
        private QualifiedName browseName;
        private LocalizedText displayName;
        private LocalizedText description = LocalizedText.NULL_VALUE;
        private UInteger writeMask = UInteger.MIN;
        private UInteger userWriteMask = UInteger.MIN;
        private boolean isAbstract = false;
        private final UaNodeContext context;

        public UaObjectTypeNodeBuilder(UaNodeContext context) {
            this.context = context;
        }

        public UaObjectTypeNodeBuilder setNodeId(NodeId nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public UaObjectTypeNodeBuilder setBrowseName(QualifiedName browseName) {
            this.browseName = browseName;
            return this;
        }

        public UaObjectTypeNodeBuilder setDisplayName(LocalizedText displayName) {
            this.displayName = displayName;
            return this;
        }

        public UaObjectTypeNodeBuilder setDescription(LocalizedText description) {
            this.description = description;
            return this;
        }

        public UaObjectTypeNodeBuilder setWriteMask(UInteger writeMask) {
            this.writeMask = writeMask;
            return this;
        }

        public UaObjectTypeNodeBuilder setUserWriteMask(UInteger userWriteMask) {
            this.userWriteMask = userWriteMask;
            return this;
        }

        public UaObjectTypeNodeBuilder setIsAbstract(boolean isAbstract) {
            this.isAbstract = isAbstract;
            return this;
        }

        public UaObjectTypeNodeBuilder addReference(Reference reference) {
            this.references.add(reference);
            return this;
        }

        @Override
        public UaObjectTypeNode get() {
            return this.build();
        }

        public UaObjectTypeNode build() {
            Preconditions.checkNotNull((Object)this.nodeId, (Object)"NodeId cannot be null");
            Preconditions.checkNotNull((Object)this.browseName, (Object)"BrowseName cannot be null");
            Preconditions.checkNotNull((Object)this.displayName, (Object)"DisplayName cannot be null");
            UaObjectTypeNode node = new UaObjectTypeNode(this.context, this.nodeId, this.browseName, this.displayName, this.description, this.writeMask, this.userWriteMask, this.isAbstract);
            this.references.forEach(node::addReference);
            return node;
        }
    }
}

