/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.api.config;

import java.util.function.Consumer;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfigBuilder;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfigLimits;
import org.eclipse.milo.opcua.sdk.server.identity.IdentityValidator;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.enumerated.UserTokenType;
import org.eclipse.milo.opcua.stack.core.types.structured.BuildInfo;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.server.UaStackServerConfig;

public interface OpcUaServerConfig
extends UaStackServerConfig {
    public static final UserTokenPolicy USER_TOKEN_POLICY_ANONYMOUS = new UserTokenPolicy("anonymous", UserTokenType.Anonymous, null, null, null);
    public static final UserTokenPolicy USER_TOKEN_POLICY_USERNAME = new UserTokenPolicy("username", UserTokenType.UserName, null, null, SecurityPolicy.Basic256.getUri());
    public static final UserTokenPolicy USER_TOKEN_POLICY_X509 = new UserTokenPolicy("certificate", UserTokenType.Certificate, null, null, SecurityPolicy.Basic256.getUri());

    public IdentityValidator getIdentityValidator();

    public BuildInfo getBuildInfo();

    public OpcUaServerConfigLimits getLimits();

    public static OpcUaServerConfigBuilder builder() {
        return new OpcUaServerConfigBuilder();
    }

    public static OpcUaServerConfigBuilder copy(OpcUaServerConfig config) {
        OpcUaServerConfigBuilder builder = new OpcUaServerConfigBuilder();
        builder.setEndpoints(config.getEndpoints());
        builder.setApplicationName(config.getApplicationName());
        builder.setApplicationUri(config.getApplicationUri());
        builder.setProductUri(config.getProductUri());
        builder.setMessageLimits(config.getMessageLimits());
        builder.setEncodingLimits(config.getEncodingLimits());
        builder.setMinimumSecureChannelLifetime(config.getMinimumSecureChannelLifetime());
        builder.setMaximumSecureChannelLifetime(config.getMaximumSecureChannelLifetime());
        builder.setCertificateManager(config.getCertificateManager());
        builder.setTrustListManager(config.getTrustListManager());
        builder.setCertificateValidator(config.getCertificateValidator());
        builder.setHttpsKeyPair(config.getHttpsKeyPair().orElse(null));
        builder.setHttpsCertificate(config.getHttpsCertificate().orElse(null));
        builder.setExecutor(config.getExecutor());
        builder.setIdentityValidator(config.getIdentityValidator());
        builder.setBuildInfo(config.getBuildInfo());
        builder.setLimits(config.getLimits());
        return builder;
    }

    public static OpcUaServerConfig copy(OpcUaServerConfig config, Consumer<OpcUaServerConfigBuilder> consumer) {
        OpcUaServerConfigBuilder builder = OpcUaServerConfig.copy(config);
        consumer.accept(builder);
        return builder.build();
    }
}

