/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.api.methods;

import java.util.Arrays;
import java.util.Optional;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.api.AccessContext;
import org.eclipse.milo.opcua.sdk.server.api.methods.MethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.server.util.AttributeUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodResult;

public abstract class AbstractMethodInvocationHandler
implements MethodInvocationHandler {
    private final UaMethodNode node;

    public AbstractMethodInvocationHandler(UaMethodNode node) {
        this.node = node;
    }

    public UaMethodNode getNode() {
        return this.node;
    }

    @Override
    public final CallMethodResult invoke(final AccessContext accessContext, final CallMethodRequest request) {
        StatusCode[] inputArgumentResults = new StatusCode[]{};
        try {
            this.checkExecutableAttributes(accessContext);
            Variant[] inputValues = request.getInputArguments();
            if (inputValues == null) {
                inputValues = new Variant[]{};
            }
            if (inputValues.length != this.getInputArguments().length) {
                throw new UaException(2155216896L);
            }
            inputArgumentResults = new StatusCode[inputValues.length];
            for (int i = 0; i < inputValues.length; ++i) {
                Argument argument = this.getInputArguments()[i];
                Variant variant = inputValues[i];
                Object value = variant.getValue();
                boolean dataTypeMatch = value == null || variant.getDataType().flatMap(xni -> xni.local(this.node.getNodeContext().getNamespaceTable())).map(type -> type.equals((Object)argument.getDataType())).orElse(false) != false;
                switch (argument.getValueRank()) {
                    case -1: {
                        if (value == null || !value.getClass().isArray()) break;
                        dataTypeMatch = false;
                        break;
                    }
                    case 0: 
                    case 1: {
                        if (value == null || value.getClass().isArray()) break;
                        dataTypeMatch = false;
                        break;
                    }
                }
                inputArgumentResults[i] = dataTypeMatch ? StatusCode.GOOD : new StatusCode(2155085824L);
            }
            if (Arrays.stream(inputArgumentResults).anyMatch(StatusCode::isBad)) {
                throw new UaException(2158690304L);
            }
            InvocationContext invocationContext = new InvocationContext(){

                @Override
                public OpcUaServer getServer() {
                    return AbstractMethodInvocationHandler.this.node.getNodeContext().getServer();
                }

                @Override
                public NodeId getObjectId() {
                    return request.getObjectId();
                }

                @Override
                public UaMethodNode getMethodNode() {
                    return AbstractMethodInvocationHandler.this.node;
                }

                @Override
                public Optional<Session> getSession() {
                    return accessContext.getSession();
                }
            };
            Variant[] outputValues = this.invoke(invocationContext, inputValues);
            return new CallMethodResult(StatusCode.GOOD, inputArgumentResults, new DiagnosticInfo[0], outputValues);
        }
        catch (UaException e) {
            return new CallMethodResult(e.getStatusCode(), inputArgumentResults, new DiagnosticInfo[0], new Variant[0]);
        }
    }

    protected void checkExecutableAttributes(AccessContext accessContext) throws UaException {
        AttributeContext attributeContext = new AttributeContext(this.node.getNodeContext().getServer(), accessContext.getSession().orElse(null));
        Boolean executable = (Boolean)AttributeUtil.extract(this.node.getAttribute(attributeContext, AttributeId.Executable));
        if (executable == null || !executable.booleanValue()) {
            throw new UaException(StatusCode.BAD);
        }
        Boolean userExecutable = (Boolean)AttributeUtil.extract(this.node.getAttribute(attributeContext, AttributeId.UserExecutable));
        if (userExecutable == null || !userExecutable.booleanValue()) {
            throw new UaException(2149515264L);
        }
    }

    public abstract Argument[] getInputArguments();

    public abstract Argument[] getOutputArguments();

    protected abstract Variant[] invoke(InvocationContext var1, Variant[] var2) throws UaException;

    public static interface InvocationContext
    extends AccessContext {
        public OpcUaServer getServer();

        public NodeId getObjectId();

        public UaMethodNode getMethodNode();
    }
}

