/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.api.services;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.server.DiagnosticsContext;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.api.AccessContext;
import org.eclipse.milo.opcua.sdk.server.api.AsyncOperationContext;
import org.eclipse.milo.opcua.sdk.server.api.ServiceOperationContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.ViewDescription;
import org.eclipse.milo.opcua.stack.core.util.Unit;

public interface ViewServices {
    default public void browse(BrowseContext context, NodeId nodeId) {
        ViewDescription view = new ViewDescription(NodeId.NULL_VALUE, DateTime.NULL_VALUE, Unsigned.uint((int)0));
        this.browse(context, view, nodeId);
    }

    public void browse(BrowseContext var1, ViewDescription var2, NodeId var3);

    public void getReferences(BrowseContext var1, ViewDescription var2, NodeId var3);

    default public void registerNodes(RegisterNodesContext context, List<NodeId> nodeIds) {
        context.success(nodeIds);
    }

    default public void unregisterNodes(UnregisterNodesContext context, List<NodeId> nodeIds) {
        context.success(Collections.nCopies(nodeIds.size(), Unit.VALUE));
    }

    default public UInteger getViewCount() {
        return Unsigned.uint((int)0);
    }

    public static final class UnregisterNodesContext
    extends ServiceOperationContext<NodeId, Unit>
    implements AccessContext {
        public UnregisterNodesContext(OpcUaServer server, @Nullable Session session) {
            super(server, session);
        }

        public UnregisterNodesContext(OpcUaServer server, @Nullable Session session, DiagnosticsContext<NodeId> diagnosticsContext) {
            super(server, session, diagnosticsContext);
        }
    }

    public static final class RegisterNodesContext
    extends ServiceOperationContext<NodeId, NodeId>
    implements AccessContext {
        public RegisterNodesContext(OpcUaServer server, @Nullable Session session) {
            super(server, session);
        }

        public RegisterNodesContext(OpcUaServer server, @Nullable Session session, DiagnosticsContext<NodeId> diagnosticsContext) {
            super(server, session, diagnosticsContext);
        }
    }

    public static final class BrowseContext
    extends AsyncOperationContext<List<Reference>>
    implements AccessContext {
        private final Session session;

        public BrowseContext(OpcUaServer server, @Nullable Session session) {
            super(server);
            this.session = session;
        }

        @Override
        public Optional<Session> getSession() {
            return Optional.ofNullable(this.session);
        }
    }
}

