/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

final class ExpandedNodeIdConversions {
    private ExpandedNodeIdConversions() {
    }

    @Nullable
    static NodeId expandedNodeIdToNodeId(@Nonnull ExpandedNodeId e) {
        return e.local(new NamespaceTable()).orElse(null);
    }

    @Nonnull
    static String expandedNodeIdToString(@Nonnull ExpandedNodeId e) {
        return e.toParseableString();
    }

    @Nullable
    static Object convert(@Nonnull Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof ExpandedNodeId) {
            ExpandedNodeId eni = (ExpandedNodeId)o;
            return implicit ? ExpandedNodeIdConversions.implicitConversion(eni, targetType) : ExpandedNodeIdConversions.explicitConversion(eni, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@Nonnull ExpandedNodeId eni, BuiltinDataType targetType) {
        switch (targetType) {
            case NodeId: {
                return ExpandedNodeIdConversions.expandedNodeIdToNodeId(eni);
            }
        }
        return ExpandedNodeIdConversions.implicitConversion(eni, targetType);
    }

    @Nullable
    static Object implicitConversion(@Nonnull ExpandedNodeId eni, BuiltinDataType targetType) {
        switch (targetType) {
            case String: {
                return ExpandedNodeIdConversions.expandedNodeIdToString(eni);
            }
        }
        return null;
    }
}

