/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.identity;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.identity.AbstractUsernameIdentityValidator;

public class UsernameIdentityValidator
extends AbstractUsernameIdentityValidator<String> {
    private final boolean anonymousAccessAllowed;
    private final Predicate<AuthenticationChallenge> predicate;

    public UsernameIdentityValidator(boolean anonymousAccessAllowed, Predicate<AuthenticationChallenge> predicate) {
        this.anonymousAccessAllowed = anonymousAccessAllowed;
        this.predicate = predicate;
    }

    @Override
    @Nullable
    protected String authenticateAnonymous(Session session) {
        if (this.anonymousAccessAllowed) {
            return String.format("anonymous_%s_%s", session.getSessionName(), session.getSessionId().toParseableString());
        }
        return null;
    }

    @Override
    @Nullable
    protected String authenticateUsernamePassword(Session session, String username, String password) {
        AuthenticationChallenge challenge = new AuthenticationChallenge(username, password);
        return this.predicate.test(challenge) ? username : null;
    }

    public static final class AuthenticationChallenge {
        private final String username;
        private final String password;

        AuthenticationChallenge(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

