/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.items;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.api.EventItem;
import org.eclipse.milo.opcua.sdk.server.events.EventContentFilter;
import org.eclipse.milo.opcua.sdk.server.events.FilterContext;
import org.eclipse.milo.opcua.sdk.server.items.BaseMonitoredItem;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.BaseEventTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.subscriptions.Subscription;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilterElementResult;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFieldList;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFilterResult;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.SimpleAttributeOperand;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoredEventItem
extends BaseMonitoredItem<Variant[]>
implements EventItem {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile EventFilter filter;
    private volatile EventFilterResult filterResult;
    private volatile boolean filterResultGood;
    private final AtomicBoolean eventOverflow = new AtomicBoolean(false);
    private final FilterContext filterContext;

    public MonitoredEventItem(final OpcUaServer server, final Session session, UInteger id, UInteger subscriptionId, ReadValueId readValueId, MonitoringMode monitoringMode, TimestampsToReturn timestamps, UInteger clientHandle, double samplingInterval, UInteger queueSize, boolean discardOldest) {
        super(server, session, id, subscriptionId, readValueId, monitoringMode, timestamps, clientHandle, samplingInterval, queueSize, discardOldest);
        this.filterContext = new FilterContext(){

            @Override
            public OpcUaServer getServer() {
                return server;
            }

            @Override
            public Optional<Session> getSession() {
                return Optional.of(session);
            }
        };
    }

    @Override
    public void onEvent(BaseEventTypeNode eventNode) {
        try {
            ContentFilter whereClause;
            boolean matches;
            if (this.filterResultGood && (matches = EventContentFilter.evaluate(this.filterContext, whereClause = this.filter.getWhereClause(), eventNode))) {
                this.enqueue(this.selectEventFields(eventNode));
            }
        }
        catch (UaException e) {
            this.logger.error("Filter evaluation failed: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Nonnull
    private Variant[] selectEventFields(BaseEventTypeNode eventNode) {
        SimpleAttributeOperand[] selectClauses = this.filter.getSelectClauses();
        if (selectClauses != null) {
            return EventContentFilter.select(this.filterContext, selectClauses, eventNode);
        }
        return new Variant[0];
    }

    @Override
    protected synchronized void enqueue(Variant[] value) {
        if (this.queue.size() < this.queue.maxSize()) {
            this.queue.add(value);
        } else {
            if (this.getQueueSize() > 1) {
                this.eventOverflow.set(true);
                Subscription subscription = this.session.getSubscriptionManager().getSubscription(this.subscriptionId);
                if (subscription != null) {
                    subscription.getSubscriptionDiagnostics().getEventQueueOverflowCount().increment();
                }
            }
            if (this.discardOldest) {
                this.queue.add(value);
            } else {
                this.queue.set(this.queue.maxSize() - 1, value);
            }
        }
    }

    @Override
    public synchronized boolean getNotifications(List<UaStructure> notifications, int max) {
        if (this.eventOverflow.compareAndSet(true, false)) {
            Variant[] eventFields = this.generateOverflowEventFields();
            if (this.discardOldest) {
                notifications.add((UaStructure)this.wrapQueueValue(eventFields));
                return super.getNotifications(notifications, max);
            }
            boolean more = super.getNotifications(notifications, max);
            notifications.add((UaStructure)this.wrapQueueValue(eventFields));
            return more;
        }
        return super.getNotifications(notifications, max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Variant[] generateOverflowEventFields() {
        UaNode overflowEvent = null;
        try {
            UUID eventId = UUID.randomUUID();
            overflowEvent = this.server.getEventFactory().createEvent(new NodeId(1, eventId), Identifiers.EventQueueOverflowEventType);
            overflowEvent.setBrowseName(new QualifiedName(1, "EventQueueOverflow"));
            overflowEvent.setDisplayName(LocalizedText.english((String)"EventQueueOverflow"));
            ByteBuffer buffer = ByteBuffer.allocate(64);
            buffer.putLong(eventId.getMostSignificantBits());
            buffer.putLong(eventId.getLeastSignificantBits());
            ((BaseEventTypeNode)overflowEvent).setEventId(ByteString.of((byte[])buffer.array()));
            ((BaseEventTypeNode)overflowEvent).setEventType(Identifiers.EventQueueOverflowEventType);
            ((BaseEventTypeNode)overflowEvent).setSourceNode(Identifiers.Server);
            ((BaseEventTypeNode)overflowEvent).setSourceName("Server");
            ((BaseEventTypeNode)overflowEvent).setTime(DateTime.now());
            ((BaseEventTypeNode)overflowEvent).setReceiveTime(DateTime.NULL_VALUE);
            ((BaseEventTypeNode)overflowEvent).setMessage(LocalizedText.english((String)"Event Queue Overflow"));
            ((BaseEventTypeNode)overflowEvent).setSeverity(Unsigned.ushort((int)0));
            Variant[] variantArray = this.selectEventFields((BaseEventTypeNode)overflowEvent);
            return variantArray;
        }
        catch (UaException e) {
            this.logger.error("Error creating overflow event: {}", (Object)e.getMessage(), (Object)e);
            Variant[] variantArray = new Variant[]{};
            return variantArray;
        }
        finally {
            if (overflowEvent != null) {
                overflowEvent.delete();
            }
        }
    }

    @Override
    public ExtensionObject getFilterResult() {
        return ExtensionObject.encode((SerializationContext)this.server.getSerializationContext(), (UaStructure)this.filterResult);
    }

    @Override
    public void installFilter(MonitoringFilter filter) throws UaException {
        if (!(filter instanceof EventFilter)) {
            this.filterResultGood = false;
            throw new UaException(0x80440000L);
        }
        this.filter = (EventFilter)filter;
        this.filterResult = EventContentFilter.validate(this.filterContext, this.filter);
        boolean selectClauseGood = ConversionUtil.l((Object[])this.filterResult.getSelectClauseResults()).stream().allMatch(StatusCode::isGood);
        boolean whereClauseGood = ConversionUtil.l((Object[])this.filterResult.getWhereClauseResult().getElementResults()).stream().map(ContentFilterElementResult::getStatusCode).allMatch(StatusCode::isGood);
        this.filterResultGood = selectClauseGood && whereClauseGood;
    }

    protected EventFieldList wrapQueueValue(Variant[] value) {
        return new EventFieldList(Unsigned.uint((long)this.getClientHandle()), value);
    }

    @Override
    public boolean isSamplingEnabled() {
        return this.getMonitoringMode() != MonitoringMode.Disabled;
    }
}

