/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.nodes.Node;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.util.AttributeReader;
import org.eclipse.milo.opcua.sdk.server.util.AttributeWriter;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;

public interface UaServerNode
extends Node {
    public UaNodeContext getNodeContext();

    public void addReference(Reference var1);

    public void removeReference(Reference var1);

    public ImmutableList<Reference> getReferences();

    default public DataValue readAttribute(AttributeContext context, UInteger attribute) {
        return this.readAttribute(context, attribute, null, null, null);
    }

    default public DataValue readAttribute(AttributeContext context, UInteger attribute, @Nullable TimestampsToReturn timestamps, @Nullable String indexRange, @Nullable QualifiedName dataEncoding) {
        return AttributeId.from((UInteger)attribute).map(attributeId -> this.readAttribute(context, (AttributeId)attributeId, timestamps, indexRange, dataEncoding)).orElse(new DataValue(2150957056L));
    }

    default public DataValue readAttribute(AttributeContext context, AttributeId attributeId, @Nullable TimestampsToReturn timestamps, @Nullable String indexRange, @Nullable QualifiedName dataEncoding) {
        return AttributeReader.readAttribute(context, this, attributeId, timestamps, indexRange, dataEncoding);
    }

    default public void writeAttribute(AttributeContext context, UInteger attribute, DataValue value, String indexRange) throws UaException {
        Optional attributeId = AttributeId.from((UInteger)attribute);
        if (!attributeId.isPresent()) {
            throw new UaException(2150957056L);
        }
        this.writeAttribute(context, (AttributeId)attributeId.get(), value, indexRange);
    }

    default public void writeAttribute(AttributeContext context, AttributeId attributeId, DataValue value, String indexRange) throws UaException {
        AttributeWriter.writeAttribute(context, this, attributeId, value, indexRange);
    }

    public DataValue getAttribute(AttributeContext var1, AttributeId var2);

    public void setAttribute(AttributeContext var1, AttributeId var2, DataValue var3) throws UaException;
}

