/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes.factories;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.nodes.ObjectTypeNode;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.ObjectTypeManager;
import org.eclipse.milo.opcua.sdk.server.VariableTypeManager;
import org.eclipse.milo.opcua.sdk.server.api.AddressSpaceManager;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaObjectTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.BrowsePath;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.InstanceDeclarationHierarchy;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.NodeTable;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.ReferenceTable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.util.Tree;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

public class NodeFactory {
    private static final Cache<NodeId, InstanceDeclarationHierarchy> IDH_CACHE = CacheBuilder.newBuilder().maximumSize(1024L).expireAfterAccess(1L, TimeUnit.HOURS).build();
    private final UaNodeContext context;
    private final ObjectTypeManager objectTypeManager;
    private final VariableTypeManager variableTypeManager;

    public static void invalidateCachedIdh(NodeId typeDefinitionId) {
        IDH_CACHE.invalidate((Object)typeDefinitionId);
    }

    public NodeFactory(UaNodeContext context) {
        this(context, context.getServer().getObjectTypeManager(), context.getServer().getVariableTypeManager());
    }

    public NodeFactory(UaNodeContext context, ObjectTypeManager objectTypeManager, VariableTypeManager variableTypeManager) {
        this.context = context;
        this.objectTypeManager = objectTypeManager;
        this.variableTypeManager = variableTypeManager;
    }

    public UaNode createNode(NodeId rootNodeId, NodeId typeDefinitionId) throws UaException {
        return this.createNode(rootNodeId, typeDefinitionId, new InstantiationCallback(){});
    }

    public UaNode createNode(NodeId rootNodeId, NodeId typeDefinitionId, InstantiationCallback instantiationCallback) throws UaException {
        Tree<UaNode> nodeTree = this.createNodeTree(rootNodeId, typeDefinitionId, instantiationCallback);
        return (UaNode)nodeTree.getValue();
    }

    public UaNode createNode(NodeId rootNodeId, ExpandedNodeId typeDefinitionId) throws UaException {
        return this.createNode(rootNodeId, typeDefinitionId, new InstantiationCallback(){});
    }

    public UaNode createNode(NodeId rootNodeId, ExpandedNodeId typeDefinitionId, InstantiationCallback instantiationCallback) throws UaException {
        NodeId localTypeDefinitionId = (NodeId)typeDefinitionId.toNodeId(this.context.getNamespaceTable()).orElseThrow(() -> new UaException(2150891520L, "typeDefinitionId not local: " + typeDefinitionId));
        return this.createNode(rootNodeId, localTypeDefinitionId, instantiationCallback);
    }

    public Tree<UaNode> createNodeTree(NodeId rootNodeId, NodeId typeDefinitionId, InstantiationCallback instantiationCallback) throws UaException {
        InstanceDeclarationHierarchy idh;
        AddressSpaceManager addressSpaceManager = this.context.getServer().getAddressSpaceManager();
        if (!addressSpaceManager.getManagedNode(typeDefinitionId).isPresent()) {
            throw new UaException(2150891520L, "unknown type definition: " + typeDefinitionId);
        }
        NamespaceTable namespaceTable = this.context.getServer().getNamespaceTable();
        try {
            idh = (InstanceDeclarationHierarchy)IDH_CACHE.get((Object)typeDefinitionId, () -> {
                LoggerFactory.getLogger(NodeFactory.class).debug("InstanceDeclarationHierarchy cache miss for typeDefinitionId={}", (Object)typeDefinitionId);
                return InstanceDeclarationHierarchy.create(addressSpaceManager, namespaceTable, typeDefinitionId);
            });
        }
        catch (ExecutionException e) {
            throw new UaException(0x80020000L, (Throwable)e);
        }
        NodeTable nodeTable = idh.getNodeTable();
        ReferenceTable referenceTable = idh.getReferenceTable();
        HashMap<BrowsePath, UaNode> nodes = new HashMap<BrowsePath, UaNode>();
        for (Map.Entry<BrowsePath, NodeId> entry : nodeTable.nodes.entrySet()) {
            UaNode instance;
            boolean optional;
            UaNode typeDefinitionNode;
            ExpandedNodeId instanceTypeDefinitionId;
            UaNode declaration;
            BrowsePath browsePath2 = entry.getKey();
            NodeId nodeId = entry.getValue();
            UaNode node2 = addressSpaceManager.getManagedNode(nodeId).orElse(null);
            if (browsePath2.parent == null) {
                UaNode instance2;
                if (node2 instanceof UaObjectTypeNode) {
                    instance2 = this.instanceFromTypeDefinition(rootNodeId, (UaObjectTypeNode)node2);
                    nodes.put(browsePath2, instance2);
                    continue;
                }
                if (node2 instanceof UaVariableTypeNode) {
                    instance2 = this.instanceFromTypeDefinition(rootNodeId, (UaVariableTypeNode)node2);
                    nodes.put(browsePath2, instance2);
                    continue;
                }
                throw new UaException(0x80020000L);
            }
            NodeId instanceNodeId = this.instanceNodeId(rootNodeId, browsePath2);
            if (node2 instanceof UaMethodNode) {
                declaration = (UaMethodNode)node2;
                UaMethodNode instance3 = new UaMethodNode(this.context, instanceNodeId, declaration.getBrowseName(), declaration.getDisplayName(), declaration.getDescription(), declaration.getWriteMask(), declaration.getUserWriteMask(), ((UaMethodNode)declaration).isExecutable(), ((UaMethodNode)declaration).isUserExecutable());
                nodes.put(browsePath2, instance3);
                continue;
            }
            if (node2 instanceof UaObjectNode) {
                declaration = (UaObjectNode)node2;
                instanceTypeDefinitionId = NodeFactory.getTypeDefinition(referenceTable, browsePath2);
                typeDefinitionNode = addressSpaceManager.getManagedNode(instanceTypeDefinitionId).orElse(null);
                if (typeDefinitionNode instanceof ObjectTypeNode) {
                    optional = this.isOptionalDeclaration(declaration);
                    if (optional && !instantiationCallback.includeOptionalNode(typeDefinitionNode.getNodeId(), declaration.getBrowseName())) continue;
                    instance = this.instanceFromTypeDefinition(instanceNodeId, (ObjectTypeNode)typeDefinitionNode);
                    instance.setBrowseName(declaration.getBrowseName());
                    instance.setDisplayName(declaration.getDisplayName());
                    instance.setDescription(declaration.getDescription());
                    instance.setWriteMask(declaration.getWriteMask());
                    instance.setUserWriteMask(declaration.getUserWriteMask());
                    ((UaObjectNode)instance).setEventNotifier(((UaObjectNode)declaration).getEventNotifier());
                    nodes.put(browsePath2, instance);
                    continue;
                }
                throw new UaException(0x80020000L, "expected type definition for " + instanceTypeDefinitionId);
            }
            if (node2 instanceof UaVariableNode) {
                declaration = (UaVariableNode)node2;
                instanceTypeDefinitionId = NodeFactory.getTypeDefinition(referenceTable, browsePath2);
                typeDefinitionNode = addressSpaceManager.getManagedNode(instanceTypeDefinitionId).orElse(null);
                if (typeDefinitionNode instanceof VariableTypeNode) {
                    optional = this.isOptionalDeclaration(declaration);
                    if (optional && !instantiationCallback.includeOptionalNode(typeDefinitionNode.getNodeId(), declaration.getBrowseName())) continue;
                    instance = this.instanceFromTypeDefinition(instanceNodeId, (VariableTypeNode)typeDefinitionNode);
                    instance.setBrowseName(declaration.getBrowseName());
                    instance.setDisplayName(declaration.getDisplayName());
                    instance.setDescription(declaration.getDescription());
                    instance.setWriteMask(declaration.getWriteMask());
                    instance.setUserWriteMask(declaration.getUserWriteMask());
                    ((UaVariableNode)instance).setValue(((UaVariableNode)declaration).getValue());
                    ((UaVariableNode)instance).setDataType(((UaVariableNode)declaration).getDataType());
                    ((UaVariableNode)instance).setValueRank(((UaVariableNode)declaration).getValueRank());
                    ((UaVariableNode)instance).setArrayDimensions(((UaVariableNode)declaration).getArrayDimensions());
                    ((UaVariableNode)instance).setAccessLevel(((UaVariableNode)declaration).getAccessLevel());
                    ((UaVariableNode)instance).setUserAccessLevel(((UaVariableNode)declaration).getUserAccessLevel());
                    nodes.put(browsePath2, instance);
                    continue;
                }
                throw new UaException(0x80020000L, "expected type definition for " + instanceTypeDefinitionId);
            }
            throw new UaException(0x80020000L, "not an instance declaration: " + node2);
        }
        nodes.forEach((browsePath, node) -> {
            List<ReferenceTable.RefRow> references = referenceTable.getReferences((BrowsePath)browsePath);
            references.forEach(t -> {
                NodeId referenceTypeId = t.nodeId;
                ReferenceTable.RefTarget target = t.target;
                if (!Identifiers.HasModellingRule.equals((Object)referenceTypeId)) {
                    if (target.targetNodeId != null) {
                        node.addReference(new Reference(node.getNodeId(), referenceTypeId, target.targetNodeId, true));
                    } else {
                        BrowsePath targetPath = target.targetPath;
                        UaNode targetNode = (UaNode)nodes.get(targetPath);
                        if (targetNode != null) {
                            node.addReference(new Reference(node.getNodeId(), referenceTypeId, targetNode.getNodeId().expanded(), true));
                        }
                    }
                }
            });
            this.context.getNodeManager().addNode((UaNode)node);
        });
        Tree nodeTree = nodeTable.getBrowsePathTree().map(nodes::get);
        this.notifyInstantiationCallback((Tree<UaNode>)nodeTree, instantiationCallback);
        return nodeTree;
    }

    protected void notifyInstantiationCallback(Tree<UaNode> nodeTree, InstantiationCallback instantiationCallback) {
        nodeTree.traverseWithParent((node, parentNode) -> {
            if (parentNode instanceof UaObjectNode && node instanceof UaMethodNode) {
                UaMethodNode methodNode = (UaMethodNode)node;
                instantiationCallback.onMethodAdded((UaObjectNode)parentNode, methodNode);
            } else if (node instanceof UaObjectNode) {
                UaObjectNode objectNode = (UaObjectNode)node;
                ObjectTypeNode objectTypeNode = objectNode.getTypeDefinitionNode();
                instantiationCallback.onObjectAdded((UaNode)parentNode, objectNode, objectTypeNode.getNodeId());
            } else if (node instanceof UaVariableNode) {
                UaVariableNode variableNode = (UaVariableNode)node;
                VariableTypeNode variableTypeNode = variableNode.getTypeDefinitionNode();
                instantiationCallback.onVariableAdded((UaNode)parentNode, variableNode, variableTypeNode.getNodeId());
            }
        });
    }

    protected NodeId instanceNodeId(NodeId rootNodeId, BrowsePath browsePath) {
        Object rootIdentifier = rootNodeId.getIdentifier();
        String instanceIdentifier = String.format("%s%s", rootIdentifier, browsePath.join());
        return new NodeId(rootNodeId.getNamespaceIndex(), instanceIdentifier);
    }

    protected UaObjectNode instanceFromTypeDefinition(NodeId nodeId, ObjectTypeNode typeDefinitionNode) {
        NodeId typeDefinitionId = typeDefinitionNode.getNodeId();
        ObjectTypeManager.ObjectNodeConstructor ctor = this.objectTypeManager.getNodeFactory(typeDefinitionId).orElse(UaObjectNode::new);
        return ctor.apply(this.context, nodeId, typeDefinitionNode.getBrowseName(), typeDefinitionNode.getDisplayName(), typeDefinitionNode.getDescription(), typeDefinitionNode.getWriteMask(), typeDefinitionNode.getUserWriteMask());
    }

    protected UaVariableNode instanceFromTypeDefinition(NodeId nodeId, VariableTypeNode typeDefinitionNode) {
        NodeId typeDefinitionId = typeDefinitionNode.getNodeId();
        VariableTypeManager.VariableNodeConstructor ctor = this.variableTypeManager.getNodeFactory(typeDefinitionId).orElse(UaVariableNode::new);
        return ctor.apply(this.context, nodeId, typeDefinitionNode.getBrowseName(), typeDefinitionNode.getDisplayName(), typeDefinitionNode.getDescription(), typeDefinitionNode.getWriteMask(), typeDefinitionNode.getUserWriteMask());
    }

    protected boolean isOptionalDeclaration(UaNode node) {
        return node.getReferences().stream().filter(r -> Identifiers.HasModellingRule.equals((Object)r.getReferenceTypeId())).anyMatch(r -> Identifiers.ModellingRule_Optional.equals(r.getTargetNodeId()));
    }

    private static ExpandedNodeId getTypeDefinition(ReferenceTable referenceTable, BrowsePath browsePath) {
        return referenceTable.getReferences(browsePath).stream().filter(t -> t.nodeId.equals((Object)Identifiers.HasTypeDefinition)).map(t -> t.target.targetNodeId).findFirst().orElse(ExpandedNodeId.NULL_VALUE);
    }

    public static interface InstantiationCallback {
        default public boolean includeOptionalNode(NodeId typeDefinitionId, QualifiedName browseName) {
            return false;
        }

        default public void onMethodAdded(@Nullable UaObjectNode parent, UaMethodNode instance) {
        }

        default public void onObjectAdded(@Nullable UaNode parent, UaObjectNode instance, NodeId typeDefinitionId) {
        }

        default public void onVariableAdded(@Nullable UaNode parent, UaVariableNode instance, NodeId typeDefinitionId) {
        }
    }
}

