/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.platform.support;

import java.io.File;
import org.eclipse.rdf4j.common.platform.AbstractPlatform;
import org.eclipse.rdf4j.common.platform.ProcessLauncher;

public class WindowsPlatform
extends AbstractPlatform {
    public static final String APPLICATION_DATA = "Application Data";
    public static final String ADUNA_APPLICATION_DATA = "RDF4J";
    private int isWin9x = 0;

    @Override
    public String getName() {
        if (this.isWin9x()) {
            return "Windows 9x";
        }
        if (this.isWinNT()) {
            return "Windows NT";
        }
        if (this.isWin2000()) {
            return "Windows 2000";
        }
        if (this.isWinXP()) {
            return "Windows XP";
        }
        if (this.isWin2003()) {
            return "Windows 2003";
        }
        if (this.isWinVista()) {
            return "Windows Vista";
        }
        return "Windows";
    }

    @Override
    public File getUserHome() {
        File result = super.getUserHome();
        String homeDrive = System.getenv("HOMEDRIVE");
        String homePath = System.getenv("HOMEPATH");
        if (homeDrive != null && homePath != null) {
            File homeDir = new File(homeDrive + homePath);
            if (homeDir.isDirectory() && homeDir.canWrite()) {
                result = homeDir;
            }
        } else {
            File userProfileDir;
            String userProfile = System.getenv("USERPROFILE");
            if (userProfile != null && (userProfileDir = new File(userProfile)).isDirectory() && userProfileDir.canWrite()) {
                result = userProfileDir;
            }
        }
        return result;
    }

    @Override
    public File getOSApplicationDataDir() {
        File appDataDir;
        File result = new File(this.getUserHome(), APPLICATION_DATA);
        String appData = System.getenv("APPDATA");
        if (appData != null && (appDataDir = new File(appData)).isDirectory() && appDataDir.canWrite()) {
            result = appDataDir;
        }
        return new File(result, ADUNA_APPLICATION_DATA);
    }

    public boolean warnsWhenOpeningExecutable() {
        return !this.isWin9x() && !this.isWinNT() && !this.isWin2000();
    }

    public boolean isWin9x() {
        if (this.isWin9x == 0) {
            try {
                ProcessLauncher launcher = new ProcessLauncher(new String[]{"cmd", "/c", "echo"});
                launcher.launch();
                this.isWin9x = -1;
            }
            catch (ProcessLauncher.CommandNotExistsException nosuchcommand) {
                this.isWin9x = 1;
            }
            catch (Exception e) {
                this.logger.error("Unexpected exception while checking isWin9x", (Throwable)e);
            }
        }
        return this.isWin9x == 1;
    }

    public boolean isWinNT() {
        return System.getProperty("os.name").toLowerCase().indexOf("nt") >= 0;
    }

    public boolean isWin2000() {
        return System.getProperty("os.name").indexOf("2000") >= 0;
    }

    public boolean isWinXP() {
        return System.getProperty("os.name").toLowerCase().indexOf("xp") >= 0;
    }

    public boolean isWin2003() {
        return System.getProperty("os.name").indexOf("2003") >= 0;
    }

    public boolean isWinVista() {
        return System.getProperty("os.name").indexOf("Vista") >= 0;
    }

    public String getCommandShell() {
        if (this.isWin9x()) {
            return "command.com";
        }
        return "cmd";
    }

    @Override
    public boolean dataDirPreserveCase() {
        return true;
    }

    @Override
    public boolean dataDirReplaceWhitespace() {
        return false;
    }

    @Override
    public boolean dataDirReplaceColon() {
        return true;
    }
}

