/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sparql;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import org.apache.http.client.HttpClient;
import org.eclipse.rdf4j.OpenRDFUtil;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.ConvertingIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.ExceptionConvertingIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.SingletonIteration;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.http.client.SPARQLProtocolSession;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.UnsupportedQueryLanguageException;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;
import org.eclipse.rdf4j.query.parser.sparql.SPARQLUtil;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.UnknownTransactionStateException;
import org.eclipse.rdf4j.repository.base.AbstractRepositoryConnection;
import org.eclipse.rdf4j.repository.sparql.SPARQLRepository;
import org.eclipse.rdf4j.repository.sparql.query.SPARQLBooleanQuery;
import org.eclipse.rdf4j.repository.sparql.query.SPARQLGraphQuery;
import org.eclipse.rdf4j.repository.sparql.query.SPARQLTupleQuery;
import org.eclipse.rdf4j.repository.sparql.query.SPARQLUpdate;
import org.eclipse.rdf4j.repository.util.RDFLoader;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;

public class SPARQLConnection
extends AbstractRepositoryConnection
implements HttpClientDependent {
    private static final String EVERYTHING = "CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o }";
    private static final String EVERYTHING_WITH_GRAPH = "SELECT * WHERE {  ?s ?p ?o . OPTIONAL { GRAPH ?ctx { ?s ?p ?o } } }";
    private static final String SOMETHING = "ASK { ?s ?p ?o }";
    private static final String SOMETHING_WITH_GRAPH = "ASK { { GRAPH ?g { ?s ?p ?o } } UNION { ?s ?p ?o } }";
    private static final String NAMEDGRAPHS = "SELECT DISTINCT ?_ WHERE { GRAPH ?_ { ?s ?p ?o } }";
    private final SPARQLProtocolSession client;
    private StringBuffer sparqlTransaction;
    private Object transactionLock = new Object();
    private final boolean quadMode;

    public SPARQLConnection(SPARQLRepository repository, SPARQLProtocolSession client) {
        this(repository, client, false);
    }

    public SPARQLConnection(SPARQLRepository repository, SPARQLProtocolSession client, boolean quadMode) {
        super((Repository)repository);
        this.client = client;
        this.quadMode = quadMode;
    }

    public String toString() {
        return this.client.getQueryURL();
    }

    public final HttpClient getHttpClient() {
        return this.client.getHttpClient();
    }

    public void setHttpClient(HttpClient httpClient) {
        this.client.setHttpClient(httpClient);
    }

    public void exportStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) throws RepositoryException, RDFHandlerException {
        try {
            GraphQuery query = this.prepareGraphQuery(QueryLanguage.SPARQL, EVERYTHING, "");
            this.setBindings((Query)query, subj, pred, obj, contexts);
            query.evaluate(handler);
        }
        catch (MalformedQueryException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryResult<Resource> getContextIDs() throws RepositoryException {
        TupleQueryResult iter = null;
        RepositoryResult result = null;
        boolean allGood = false;
        try {
            TupleQuery query = this.prepareTupleQuery(QueryLanguage.SPARQL, NAMEDGRAPHS, "");
            iter = query.evaluate();
            result = new RepositoryResult((CloseableIteration)new ExceptionConvertingIteration<Resource, RepositoryException>((Iteration)new ConvertingIteration<BindingSet, Resource, QueryEvaluationException>((Iteration)iter){

                protected Resource convert(BindingSet bindings) throws QueryEvaluationException {
                    return (Resource)bindings.getValue("_");
                }
            }){

                protected RepositoryException convert(Exception e) {
                    return new RepositoryException((Throwable)e);
                }
            });
            allGood = true;
            RepositoryResult repositoryResult = result;
            return repositoryResult;
        }
        catch (MalformedQueryException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            if (!allGood) {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    if (iter != null) {
                        iter.close();
                    }
                }
            }
        }
    }

    public String getNamespace(String prefix) throws RepositoryException {
        return null;
    }

    public RepositoryResult<Namespace> getNamespaces() throws RepositoryException {
        return new RepositoryResult((CloseableIteration)new EmptyIteration());
    }

    public boolean isEmpty() throws RepositoryException {
        try {
            BooleanQuery query = this.isQuadMode() ? this.prepareBooleanQuery(QueryLanguage.SPARQL, SOMETHING_WITH_GRAPH) : this.prepareBooleanQuery(QueryLanguage.SPARQL, SOMETHING);
            return !query.evaluate();
        }
        catch (MalformedQueryException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size(Resource ... contexts) throws RepositoryException {
        try (RepositoryResult<Statement> stmts = this.getStatements(null, null, null, true, contexts);){
            long i = 0L;
            while (stmts.hasNext()) {
                stmts.next();
                ++i;
            }
            long l = i;
            return l;
        }
    }

    public RepositoryResult<Statement> getStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        try {
            if (this.isQuadMode()) {
                return this.getStatementsQuadMode(subj, pred, obj, includeInferred, contexts);
            }
            if (subj != null && pred != null && obj != null) {
                return this.getStatementsSingleTriple(subj, pred, obj, includeInferred, contexts);
            }
            return this.getStatementGeneral(subj, pred, obj, includeInferred, contexts);
        }
        catch (MalformedQueryException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RepositoryResult<Statement> getStatementsQuadMode(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws MalformedQueryException, RepositoryException, QueryEvaluationException {
        TupleQueryResult qRes = null;
        RepositoryResult result = null;
        boolean allGood = false;
        try {
            TupleQuery tupleQuery = this.prepareTupleQuery(QueryLanguage.SPARQL, EVERYTHING_WITH_GRAPH);
            this.setBindings((Query)tupleQuery, subj, pred, obj, contexts);
            tupleQuery.setIncludeInferred(includeInferred);
            qRes = tupleQuery.evaluate();
            result = new RepositoryResult((CloseableIteration)new ExceptionConvertingIteration<Statement, RepositoryException>(this.toStatementIteration(qRes, subj, pred, obj)){

                protected RepositoryException convert(Exception e) {
                    return new RepositoryException((Throwable)e);
                }
            });
            allGood = true;
            RepositoryResult repositoryResult = result;
            return repositoryResult;
        }
        finally {
            if (!allGood) {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    if (qRes != null) {
                        qRes.close();
                    }
                }
            }
        }
    }

    private RepositoryResult<Statement> getStatementsSingleTriple(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        if (this.hasStatement(subj, pred, obj, includeInferred, contexts)) {
            Statement st = this.getValueFactory().createStatement(subj, pred, obj);
            SingletonIteration cursor = new SingletonIteration((Object)st);
            return new RepositoryResult((CloseableIteration)cursor);
        }
        return new RepositoryResult((CloseableIteration)new EmptyIteration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RepositoryResult<Statement> getStatementGeneral(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        GraphQueryResult gRes = null;
        RepositoryResult result = null;
        boolean allGood = false;
        try {
            GraphQuery query = this.prepareGraphQuery(QueryLanguage.SPARQL, EVERYTHING, "");
            query.setIncludeInferred(includeInferred);
            this.setBindings((Query)query, subj, pred, obj, contexts);
            gRes = query.evaluate();
            result = new RepositoryResult((CloseableIteration)new ExceptionConvertingIteration<Statement, RepositoryException>((Iteration)gRes){

                protected RepositoryException convert(Exception e) {
                    return new RepositoryException((Throwable)e);
                }
            });
            allGood = true;
            RepositoryResult repositoryResult = result;
            return repositoryResult;
        }
        finally {
            if (!allGood) {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    if (gRes != null) {
                        gRes.close();
                    }
                }
            }
        }
    }

    public boolean hasStatement(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        try {
            BooleanQuery query = this.prepareBooleanQuery(QueryLanguage.SPARQL, SOMETHING, "");
            this.setBindings((Query)query, subj, pred, obj, contexts);
            return query.evaluate();
        }
        catch (MalformedQueryException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public SPARQLRepository getRepository() {
        return (SPARQLRepository)super.getRepository();
    }

    public Query prepareQuery(QueryLanguage ql, String query, String base) throws RepositoryException, MalformedQueryException {
        if (QueryLanguage.SPARQL.equals((Object)ql)) {
            String strippedQuery = QueryParserUtil.removeSPARQLQueryProlog((String)query).toUpperCase();
            if (strippedQuery.startsWith("SELECT")) {
                return this.prepareTupleQuery(ql, query, base);
            }
            if (strippedQuery.startsWith("ASK")) {
                return this.prepareBooleanQuery(ql, query, base);
            }
            return this.prepareGraphQuery(ql, query, base);
        }
        throw new UnsupportedOperationException("Unsupported query language " + ql);
    }

    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query, String base) throws RepositoryException, MalformedQueryException {
        if (QueryLanguage.SPARQL.equals((Object)ql)) {
            return new SPARQLBooleanQuery(this.client, base, query);
        }
        throw new UnsupportedQueryLanguageException("Unsupported query language " + ql);
    }

    public GraphQuery prepareGraphQuery(QueryLanguage ql, String query, String base) throws RepositoryException, MalformedQueryException {
        if (QueryLanguage.SPARQL.equals((Object)ql)) {
            return new SPARQLGraphQuery(this.client, base, query);
        }
        throw new UnsupportedQueryLanguageException("Unsupported query language " + ql);
    }

    public TupleQuery prepareTupleQuery(QueryLanguage ql, String query, String base) throws RepositoryException, MalformedQueryException {
        if (QueryLanguage.SPARQL.equals((Object)ql)) {
            return new SPARQLTupleQuery(this.client, base, query);
        }
        throw new UnsupportedQueryLanguageException("Unsupported query language " + ql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RepositoryException {
        Object object = this.transactionLock;
        synchronized (object) {
            if (this.isActive()) {
                Object object2 = this.transactionLock;
                synchronized (object2) {
                    SPARQLUpdate transaction = new SPARQLUpdate(this.client, null, this.sparqlTransaction.toString());
                    try {
                        transaction.execute();
                    }
                    catch (UpdateExecutionException e) {
                        throw new RepositoryException("error executing transaction", (Throwable)e);
                    }
                    this.sparqlTransaction = null;
                }
            }
            throw new RepositoryException("no transaction active.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws RepositoryException {
        Object object = this.transactionLock;
        synchronized (object) {
            if (this.isActive()) {
                Object object2 = this.transactionLock;
                synchronized (object2) {
                    this.sparqlTransaction = null;
                }
            } else {
                throw new RepositoryException("no transaction active.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() throws RepositoryException {
        Object object = this.transactionLock;
        synchronized (object) {
            if (!this.isActive()) {
                Object object2 = this.transactionLock;
                synchronized (object2) {
                    this.sparqlTransaction = new StringBuffer();
                }
            } else {
                throw new RepositoryException("active transaction already exists");
            }
        }
    }

    public void add(File file, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        StatementCollector collector = new StatementCollector();
        boolean localTransaction = this.startLocalTransaction();
        try {
            RDFLoader loader = new RDFLoader(this.getParserConfig(), this.getValueFactory());
            loader.load(file, baseURI, dataFormat, (RDFHandler)collector);
            this.add(collector.getStatements(), contexts);
            this.conditionalCommit(localTransaction);
        }
        catch (RDFHandlerException e) {
            this.conditionalRollback(localTransaction);
            throw (RepositoryException)e.getCause();
        }
        catch (RDFParseException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (IOException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (RuntimeException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    public void add(URL url, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        StatementCollector collector = new StatementCollector();
        boolean localTransaction = this.startLocalTransaction();
        try {
            RDFLoader loader = new RDFLoader(this.getParserConfig(), this.getValueFactory());
            loader.load(url, baseURI, dataFormat, (RDFHandler)collector);
            this.add(collector.getStatements(), contexts);
            this.conditionalCommit(localTransaction);
        }
        catch (RDFHandlerException e) {
            this.conditionalRollback(localTransaction);
            throw (RepositoryException)e.getCause();
        }
        catch (RDFParseException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (IOException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (RuntimeException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    public void add(InputStream in, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        StatementCollector collector = new StatementCollector();
        boolean localTransaction = this.startLocalTransaction();
        try {
            RDFLoader loader = new RDFLoader(this.getParserConfig(), this.getValueFactory());
            loader.load(in, baseURI, dataFormat, (RDFHandler)collector);
            this.add(collector.getStatements(), contexts);
            this.conditionalCommit(localTransaction);
        }
        catch (RDFHandlerException e) {
            this.conditionalRollback(localTransaction);
            throw (RepositoryException)e.getCause();
        }
        catch (RDFParseException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (IOException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (RuntimeException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    public void add(Reader reader, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        StatementCollector collector = new StatementCollector();
        boolean localTransaction = this.startLocalTransaction();
        try {
            RDFLoader loader = new RDFLoader(this.getParserConfig(), this.getValueFactory());
            loader.load(reader, baseURI, dataFormat, (RDFHandler)collector);
            this.add(collector.getStatements(), contexts);
            this.conditionalCommit(localTransaction);
        }
        catch (RDFHandlerException e) {
            this.conditionalRollback(localTransaction);
            throw (RepositoryException)e.getCause();
        }
        catch (RDFParseException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (IOException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (RuntimeException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    public void add(Statement st, Resource ... contexts) throws RepositoryException {
        boolean localTransaction = this.startLocalTransaction();
        ArrayList<Statement> list = new ArrayList<Statement>(1);
        list.add(st);
        String sparqlCommand = this.createInsertDataCommand(list, contexts);
        this.sparqlTransaction.append(sparqlCommand);
        this.sparqlTransaction.append("; ");
        try {
            this.conditionalCommit(localTransaction);
        }
        catch (RepositoryException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    public void add(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        boolean localTransaction = this.startLocalTransaction();
        String sparqlCommand = this.createInsertDataCommand(statements, contexts);
        this.sparqlTransaction.append(sparqlCommand);
        this.sparqlTransaction.append("; ");
        try {
            this.conditionalCommit(localTransaction);
        }
        catch (RepositoryException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    public void clear(Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        boolean localTransaction = this.startLocalTransaction();
        if (contexts.length == 0) {
            this.sparqlTransaction.append("CLEAR ALL ");
            this.sparqlTransaction.append("; ");
        } else {
            for (Resource context : contexts) {
                if (context == null) {
                    this.sparqlTransaction.append("CLEAR DEFAULT ");
                    this.sparqlTransaction.append("; ");
                    continue;
                }
                if (context instanceof IRI) {
                    this.sparqlTransaction.append("CLEAR GRAPH <" + context.stringValue() + "> ");
                    this.sparqlTransaction.append("; ");
                    continue;
                }
                throw new RepositoryException("SPARQL does not support named graphs identified by blank nodes.");
            }
        }
        try {
            this.conditionalCommit(localTransaction);
        }
        catch (RepositoryException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    public void clearNamespaces() throws RepositoryException {
    }

    public void remove(Statement st, Resource ... contexts) throws RepositoryException {
        boolean localTransaction = this.startLocalTransaction();
        ArrayList<Statement> list = new ArrayList<Statement>(1);
        list.add(st);
        String sparqlCommand = this.createDeleteDataCommand(list, contexts);
        this.sparqlTransaction.append(sparqlCommand);
        this.sparqlTransaction.append("; ");
        try {
            this.conditionalCommit(localTransaction);
        }
        catch (RepositoryException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    public void remove(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        boolean localTransaction = this.startLocalTransaction();
        String sparqlCommand = this.createDeleteDataCommand(statements, contexts);
        this.sparqlTransaction.append(sparqlCommand);
        this.sparqlTransaction.append("; ");
        try {
            this.conditionalCommit(localTransaction);
        }
        catch (RepositoryException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    public void removeNamespace(String prefix) throws RepositoryException {
    }

    public void setNamespace(String prefix, String name) throws RepositoryException {
    }

    public Update prepareUpdate(QueryLanguage ql, String update, String baseURI) throws RepositoryException, MalformedQueryException {
        if (QueryLanguage.SPARQL.equals((Object)ql)) {
            return new SPARQLUpdate(this.client, baseURI, update);
        }
        throw new UnsupportedQueryLanguageException("Unsupported query language " + ql);
    }

    private void setBindings(Query query, Resource subj, IRI pred, Value obj, Resource ... contexts) throws RepositoryException {
        if (subj != null) {
            query.setBinding("s", (Value)subj);
        }
        if (pred != null) {
            query.setBinding("p", (Value)pred);
        }
        if (obj != null) {
            query.setBinding("o", obj);
        }
        if (contexts != null && contexts.length > 0) {
            SimpleDataset dataset = new SimpleDataset();
            for (Resource ctx : contexts) {
                if (ctx != null && !(ctx instanceof IRI)) {
                    throw new RepositoryException("Contexts must be URIs");
                }
                dataset.addDefaultGraph((IRI)ctx);
            }
            query.setDataset((Dataset)dataset);
        }
    }

    private String createInsertDataCommand(Iterable<? extends Statement> statements, Resource ... contexts) {
        StringBuilder qb = new StringBuilder();
        qb.append("INSERT DATA \n");
        qb.append("{ \n");
        if (contexts.length > 0) {
            for (Resource context : contexts) {
                if (context != null) {
                    String namedGraph = context.stringValue();
                    if (context instanceof BNode) {
                        namedGraph = "urn:nodeid:" + context.stringValue();
                    }
                    qb.append("    GRAPH <" + namedGraph + "> { \n");
                }
                this.createDataBody(qb, statements, true);
                if (context == null) continue;
                qb.append(" } \n");
            }
        } else {
            this.createDataBody(qb, statements, false);
        }
        qb.append("}");
        return qb.toString();
    }

    private String createDeleteDataCommand(Iterable<? extends Statement> statements, Resource ... contexts) {
        StringBuilder qb = new StringBuilder();
        qb.append("DELETE DATA \n");
        qb.append("{ \n");
        if (contexts.length > 0) {
            for (Resource context : contexts) {
                if (context != null) {
                    String namedGraph = context.stringValue();
                    if (context instanceof BNode) {
                        namedGraph = "urn:nodeid:" + context.stringValue();
                    }
                    qb.append("    GRAPH <" + namedGraph + "> { \n");
                }
                this.createDataBody(qb, statements, true);
                if (context == null) continue;
                qb.append(" } \n");
            }
        } else {
            this.createDataBody(qb, statements, false);
        }
        qb.append("}");
        return qb.toString();
    }

    private void createDataBody(StringBuilder qb, Iterable<? extends Statement> statements, boolean ignoreContext) {
        for (Statement statement : statements) {
            Resource context = statement.getContext();
            if (!ignoreContext && context != null) {
                String namedGraph = context.stringValue();
                if (context instanceof BNode) {
                    namedGraph = "urn:nodeid:" + context.stringValue();
                }
                qb.append("    GRAPH <" + namedGraph + "> { \n");
            }
            if (statement.getSubject() instanceof BNode) {
                qb.append("_:" + statement.getSubject().stringValue() + " ");
            } else {
                qb.append("<" + statement.getSubject().stringValue() + "> ");
            }
            qb.append("<" + statement.getPredicate().stringValue() + "> ");
            if (statement.getObject() instanceof Literal) {
                Literal lit = (Literal)statement.getObject();
                qb.append("\"");
                qb.append(SPARQLUtil.encodeString((String)lit.getLabel()));
                qb.append("\"");
                if (Literals.isLanguageLiteral((Literal)lit)) {
                    qb.append("@");
                    qb.append((String)lit.getLanguage().get());
                } else {
                    qb.append("^^<" + lit.getDatatype().stringValue() + ">");
                }
                qb.append(" ");
            } else if (statement.getObject() instanceof BNode) {
                qb.append("_:" + statement.getObject().stringValue() + " ");
            } else {
                qb.append("<" + statement.getObject().stringValue() + "> ");
            }
            qb.append(". \n");
            if (ignoreContext || context == null) continue;
            qb.append("    }\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() throws UnknownTransactionStateException, RepositoryException {
        Object object = this.transactionLock;
        synchronized (object) {
            return this.sparqlTransaction != null;
        }
    }

    protected void addWithoutCommit(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        ValueFactory f = this.getValueFactory();
        Statement st = f.createStatement(subject, predicate, object);
        ArrayList<Statement> list = new ArrayList<Statement>(1);
        list.add(st);
        String sparqlCommand = this.createInsertDataCommand(list, contexts);
        this.sparqlTransaction.append(sparqlCommand);
        this.sparqlTransaction.append("; ");
    }

    protected void removeWithoutCommit(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        String sparqlCommand = "";
        if (subject != null && predicate != null && object != null) {
            ValueFactory f = this.getValueFactory();
            Statement st = f.createStatement(subject, predicate, object);
            ArrayList<Statement> list = new ArrayList<Statement>(1);
            list.add(st);
            sparqlCommand = this.createDeleteDataCommand(list, contexts);
        } else {
            sparqlCommand = this.createDeletePatternCommand(subject, predicate, object, contexts);
        }
        this.sparqlTransaction.append(sparqlCommand);
        this.sparqlTransaction.append("; ");
    }

    private String createDeletePatternCommand(Resource subject, IRI predicate, Value object, Resource[] contexts) {
        StringBuilder qb = new StringBuilder();
        qb.append("DELETE WHERE \n");
        qb.append("{ \n");
        if (contexts.length > 0) {
            for (Resource context : contexts) {
                if (context != null) {
                    String namedGraph = context.stringValue();
                    if (context instanceof BNode) {
                        namedGraph = "urn:nodeid:" + context.stringValue();
                    }
                    qb.append("    GRAPH <" + namedGraph + "> { \n");
                }
                this.createBGP(qb, subject, predicate, object);
                if (context == null || !(context instanceof IRI)) continue;
                qb.append(" } \n");
            }
        } else {
            this.createBGP(qb, subject, predicate, object);
        }
        qb.append("}");
        return qb.toString();
    }

    private void createBGP(StringBuilder qb, Resource subject, IRI predicate, Value object) {
        if (subject != null) {
            if (subject instanceof BNode) {
                qb.append("_:" + subject.stringValue() + " ");
            } else {
                qb.append("<" + subject.stringValue() + "> ");
            }
        } else {
            qb.append("?subj");
        }
        if (predicate != null) {
            qb.append("<" + predicate.stringValue() + "> ");
        } else {
            qb.append("?pred");
        }
        if (object != null) {
            if (object instanceof Literal) {
                Literal lit = (Literal)object;
                qb.append("\"");
                qb.append(SPARQLUtil.encodeString((String)lit.getLabel()));
                qb.append("\"");
                if (lit.getLanguage().isPresent()) {
                    qb.append("@");
                    qb.append((String)lit.getLanguage().get());
                } else {
                    qb.append("^^<" + lit.getDatatype().stringValue() + ">");
                }
                qb.append(" ");
            } else if (object instanceof BNode) {
                qb.append("_:" + object.stringValue() + " ");
            } else {
                qb.append("<" + object.stringValue() + "> ");
            }
        } else {
            qb.append("?obj");
        }
        qb.append(". \n");
    }

    protected boolean isQuadMode() {
        return this.quadMode;
    }

    protected Iteration<Statement, QueryEvaluationException> toStatementIteration(TupleQueryResult iter, final Resource subj, final IRI pred, final Value obj) {
        return new ConvertingIteration<BindingSet, Statement, QueryEvaluationException>((Iteration)iter){

            protected Statement convert(BindingSet b) throws QueryEvaluationException {
                Resource s = subj == null ? (Resource)b.getValue("s") : subj;
                IRI p = pred == null ? (IRI)b.getValue("p") : pred;
                Value o = obj == null ? b.getValue("o") : obj;
                Resource ctx = (Resource)b.getValue("ctx");
                return SimpleValueFactory.getInstance().createStatement(s, p, o, ctx);
            }
        };
    }
}

