/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.inferencer.fc;

import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConnectionListener;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.UnknownSailTransactionStateException;
import org.eclipse.rdf4j.sail.inferencer.InferencerConnection;
import org.eclipse.rdf4j.sail.inferencer.InferencerConnectionWrapper;
import org.eclipse.rdf4j.sail.inferencer.fc.SchemaCachingRDFSInferencer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaCachingRDFSInferencerConnection
extends InferencerConnectionWrapper
implements SailConnectionListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SchemaCachingRDFSInferencer sail;
    private final NotifyingSailConnection connection;
    private boolean statementsRemoved;
    private boolean statementsAdded;
    private boolean inferredCleared = false;
    private long originalSchemaSize = -1L;

    SchemaCachingRDFSInferencerConnection(SchemaCachingRDFSInferencer sail, InferencerConnection connection) {
        super(connection);
        connection.addConnectionListener(this);
        this.sail = sail;
        this.connection = connection;
    }

    void processForSchemaCache(Statement statement) {
        this.sail.acquireExclusiveWriteLock();
        IRI predicate = statement.getPredicate();
        Value object = statement.getObject();
        Resource subject = statement.getSubject();
        if (predicate.equals((Object)RDFS.SUBCLASSOF)) {
            this.sail.addSubClassOfStatement(statement);
        } else if (predicate.equals((Object)RDF.TYPE) && object.equals(RDF.PROPERTY)) {
            this.sail.addProperty(subject);
        } else if (predicate.equals((Object)RDFS.SUBPROPERTYOF)) {
            this.sail.addSubPropertyOfStatement(statement);
        } else if (predicate.equals((Object)RDFS.RANGE)) {
            this.sail.addRangeStatement(statement);
        } else if (predicate.equals((Object)RDFS.DOMAIN)) {
            this.sail.addDomainStatement(statement);
        } else if (predicate.equals((Object)RDF.TYPE) && object.equals(RDFS.CLASS)) {
            this.sail.addSubClassOfStatement(this.sail.getValueFactory().createStatement(subject, RDFS.SUBCLASSOF, (Value)RDFS.RESOURCE));
        } else if (predicate.equals((Object)RDF.TYPE) && object.equals(RDFS.DATATYPE)) {
            this.sail.addSubClassOfStatement(this.sail.getValueFactory().createStatement(subject, RDFS.SUBCLASSOF, (Value)RDFS.LITERAL));
        } else if (predicate.equals((Object)RDF.TYPE) && object.equals(RDFS.CONTAINERMEMBERSHIPPROPERTY)) {
            this.sail.addSubPropertyOfStatement(this.sail.getValueFactory().createStatement(subject, RDFS.SUBPROPERTYOF, (Value)RDFS.MEMBER));
        } else if (predicate.equals((Object)RDF.TYPE) && !this.sail.hasType((Resource)object)) {
            this.sail.addType((Resource)object);
        }
        if (!this.sail.hasProperty((Resource)predicate)) {
            this.sail.addProperty((Resource)predicate);
        }
    }

    @Override
    public void clearInferred(Resource ... contexts) throws SailException {
        super.clearInferred(contexts);
        this.inferredCleared = true;
    }

    @Override
    public void commit() throws SailException {
        super.commit();
        this.sail.releaseExclusiveWriteLock();
    }

    void doInferencing() throws SailException {
        if (this.sail.schema == null && this.originalSchemaSize != this.sail.getSchemaSize()) {
            this.regenerateCacheAndInferenceMaps();
            this.inferredCleared = true;
        }
        if (!this.inferredCleared) {
            return;
        }
        try (CloseableIteration<? extends Statement, SailException> statements = this.connection.getStatements((Resource)null, (IRI)null, (Value)null, false, new Resource[0]);){
            while (statements.hasNext()) {
                Statement next = (Statement)statements.next();
                this.addStatement(false, next.getSubject(), next.getPredicate(), next.getObject(), next.getContext());
            }
        }
        this.inferredCleared = false;
    }

    private void regenerateCacheAndInferenceMaps() {
        this.sail.clearInferenceTables();
        this.addAxiomStatements();
        try (CloseableIteration<? extends Statement, SailException> statements = this.connection.getStatements((Resource)null, (IRI)null, (Value)null, false, new Resource[0]);){
            while (statements.hasNext()) {
                Statement next = (Statement)statements.next();
                this.processForSchemaCache(next);
            }
        }
        this.sail.calculateInferenceMaps(this);
        this.originalSchemaSize = this.sail.getSchemaSize();
    }

    @Override
    public void addStatement(Resource subject, IRI predicate, Value object, Resource ... contexts) throws SailException {
        this.addStatement(true, subject, predicate, object, contexts);
    }

    private void addStatement(boolean actuallyAdd, Resource subject, IRI predicate, Value object, Resource ... resources) throws SailException {
        this.sail.acquireExclusiveWriteLock();
        if (this.sail.schema == null) {
            this.processForSchemaCache(this.sail.getValueFactory().createStatement(subject, predicate, object));
        }
        if (this.sail.useAllRdfsRules) {
            this.addInferredStatement(subject, RDF.TYPE, (Value)RDFS.RESOURCE, new Resource[0]);
            if (object instanceof Resource) {
                this.addInferredStatement((Resource)object, RDF.TYPE, (Value)RDFS.RESOURCE, new Resource[0]);
            }
        }
        if (predicate.getNamespace().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#") && predicate.getLocalName().charAt(0) == '_') {
            try {
                int i = Integer.parseInt(predicate.getLocalName().substring(1));
                if (i >= 1) {
                    this.addInferredStatement(subject, RDFS.MEMBER, object, new Resource[0]);
                    this.addInferredStatement((Resource)predicate, RDF.TYPE, (Value)RDFS.RESOURCE, new Resource[0]);
                    this.addInferredStatement((Resource)predicate, RDF.TYPE, (Value)RDFS.CONTAINERMEMBERSHIPPROPERTY, new Resource[0]);
                    this.addInferredStatement((Resource)predicate, RDF.TYPE, (Value)RDF.PROPERTY, new Resource[0]);
                    this.addInferredStatement((Resource)predicate, RDFS.SUBPROPERTYOF, (Value)predicate, new Resource[0]);
                    this.addInferredStatement((Resource)predicate, RDFS.SUBPROPERTYOF, (Value)RDFS.MEMBER, new Resource[0]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (actuallyAdd) {
            this.connection.addStatement(subject, predicate, object, resources);
        }
        if (predicate.equals((Object)RDF.TYPE)) {
            if (!(object instanceof Resource)) {
                throw new SailException("Expected object to a a Resource: " + object.toString());
            }
            this.sail.resolveTypes((Resource)object).stream().peek(inferredType -> {
                if (this.sail.useAllRdfsRules && inferredType.equals(RDFS.CLASS)) {
                    this.addInferredStatement(subject, RDFS.SUBCLASSOF, (Value)RDFS.RESOURCE, new Resource[0]);
                }
            }).filter(inferredType -> !inferredType.equals(object)).forEach(inferredType -> this.addInferredStatement(subject, RDF.TYPE, (Value)inferredType, new Resource[0]));
        }
        this.sail.resolveProperties((Resource)predicate).stream().filter(inferredProperty -> !inferredProperty.equals(predicate)).filter(inferredPropery -> inferredPropery instanceof IRI).map(inferredPropery -> (IRI)inferredPropery).forEach(inferredProperty -> this.addInferredStatement(subject, (IRI)inferredProperty, object, new Resource[0]));
        if (object instanceof Resource) {
            this.sail.resolveRangeTypes(predicate).stream().peek(inferredType -> {
                if (this.sail.useAllRdfsRules && inferredType.equals(RDFS.CLASS)) {
                    this.addInferredStatement((Resource)object, RDFS.SUBCLASSOF, (Value)RDFS.RESOURCE, new Resource[0]);
                }
            }).forEach(inferredType -> this.addInferredStatement((Resource)object, RDF.TYPE, (Value)inferredType, new Resource[0]));
        }
        this.sail.resolveDomainTypes(predicate).stream().peek(inferredType -> {
            if (this.sail.useAllRdfsRules && inferredType.equals(RDFS.CLASS)) {
                this.addInferredStatement(subject, RDFS.SUBCLASSOF, (Value)RDFS.RESOURCE, new Resource[0]);
            }
        }).forEach(inferredType -> this.addInferredStatement(subject, RDF.TYPE, (Value)inferredType, new Resource[0]));
    }

    void addAxiomStatements() {
        this.sail.acquireExclusiveWriteLock();
        ValueFactory vf = this.sail.getValueFactory();
        Statement statement = vf.createStatement((Resource)RDF.ALT, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.ALT, RDF.TYPE, (Value)RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.ALT, RDFS.SUBCLASSOF, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.ALT, RDFS.SUBCLASSOF, (Value)RDFS.CONTAINER);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.ALT, RDFS.SUBCLASSOF, (Value)RDF.ALT);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.BAG, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.BAG, RDF.TYPE, (Value)RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.BAG, RDFS.SUBCLASSOF, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.BAG, RDFS.SUBCLASSOF, (Value)RDFS.CONTAINER);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.BAG, RDFS.SUBCLASSOF, (Value)RDF.BAG);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.LIST, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.LIST, RDF.TYPE, (Value)RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.LIST, RDFS.SUBCLASSOF, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.LIST, RDFS.SUBCLASSOF, (Value)RDF.LIST);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.PROPERTY, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.PROPERTY, RDF.TYPE, (Value)RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.PROPERTY, RDFS.SUBCLASSOF, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.PROPERTY, RDFS.SUBCLASSOF, (Value)RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.SEQ, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.SEQ, RDF.TYPE, (Value)RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.SEQ, RDFS.SUBCLASSOF, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.SEQ, RDFS.SUBCLASSOF, (Value)RDFS.CONTAINER);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.SEQ, RDFS.SUBCLASSOF, (Value)RDF.SEQ);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.STATEMENT, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.STATEMENT, RDF.TYPE, (Value)RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.STATEMENT, RDFS.SUBCLASSOF, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.STATEMENT, RDFS.SUBCLASSOF, (Value)RDF.STATEMENT);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.XMLLITERAL, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.XMLLITERAL, RDF.TYPE, (Value)RDFS.DATATYPE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.XMLLITERAL, RDF.TYPE, (Value)RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.XMLLITERAL, RDFS.SUBCLASSOF, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.XMLLITERAL, RDFS.SUBCLASSOF, (Value)RDFS.LITERAL);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.XMLLITERAL, RDFS.SUBCLASSOF, (Value)RDF.XMLLITERAL);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.FIRST, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.FIRST, RDF.TYPE, (Value)RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.FIRST, RDFS.DOMAIN, (Value)RDF.LIST);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.FIRST, RDFS.RANGE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.FIRST, RDFS.SUBPROPERTYOF, (Value)RDF.FIRST);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.NIL, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.OBJECT, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.OBJECT, RDF.TYPE, (Value)RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.OBJECT, RDFS.DOMAIN, (Value)RDF.STATEMENT);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.OBJECT, RDFS.RANGE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.OBJECT, RDFS.SUBPROPERTYOF, (Value)RDF.OBJECT);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.PREDICATE, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.PREDICATE, RDF.TYPE, (Value)RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.PREDICATE, RDFS.DOMAIN, (Value)RDF.STATEMENT);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.PREDICATE, RDFS.RANGE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.PREDICATE, RDFS.SUBPROPERTYOF, (Value)RDF.PREDICATE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.REST, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.REST, RDF.TYPE, (Value)RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.REST, RDFS.DOMAIN, (Value)RDF.LIST);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.REST, RDFS.RANGE, (Value)RDF.LIST);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.REST, RDFS.SUBPROPERTYOF, (Value)RDF.REST);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.SUBJECT, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.SUBJECT, RDF.TYPE, (Value)RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.SUBJECT, RDFS.DOMAIN, (Value)RDF.STATEMENT);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.SUBJECT, RDFS.RANGE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.SUBJECT, RDFS.SUBPROPERTYOF, (Value)RDF.SUBJECT);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.TYPE, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.TYPE, RDF.TYPE, (Value)RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.TYPE, RDFS.DOMAIN, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.TYPE, RDFS.RANGE, (Value)RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.TYPE, RDFS.SUBPROPERTYOF, (Value)RDF.TYPE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.VALUE, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.VALUE, RDF.TYPE, (Value)RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.VALUE, RDFS.DOMAIN, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.VALUE, RDFS.RANGE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDF.VALUE, RDFS.SUBPROPERTYOF, (Value)RDF.VALUE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.CLASS, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.CLASS, RDF.TYPE, (Value)RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.CLASS, RDFS.SUBCLASSOF, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.CLASS, RDFS.SUBCLASSOF, (Value)RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.CONTAINER, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.CONTAINER, RDF.TYPE, (Value)RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.CONTAINER, RDFS.SUBCLASSOF, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.CONTAINER, RDFS.SUBCLASSOF, (Value)RDFS.CONTAINER);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.CONTAINERMEMBERSHIPPROPERTY, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.CONTAINERMEMBERSHIPPROPERTY, RDF.TYPE, (Value)RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.CONTAINERMEMBERSHIPPROPERTY, RDFS.SUBCLASSOF, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.CONTAINERMEMBERSHIPPROPERTY, RDFS.SUBCLASSOF, (Value)RDFS.CONTAINERMEMBERSHIPPROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.CONTAINERMEMBERSHIPPROPERTY, RDFS.SUBCLASSOF, (Value)RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.DATATYPE, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.DATATYPE, RDF.TYPE, (Value)RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.DATATYPE, RDFS.SUBCLASSOF, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.DATATYPE, RDFS.SUBCLASSOF, (Value)RDFS.DATATYPE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.DATATYPE, RDFS.SUBCLASSOF, (Value)RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.LITERAL, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.LITERAL, RDF.TYPE, (Value)RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.LITERAL, RDFS.SUBCLASSOF, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.LITERAL, RDFS.SUBCLASSOF, (Value)RDFS.LITERAL);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.RESOURCE, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.RESOURCE, RDF.TYPE, (Value)RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.RESOURCE, RDFS.SUBCLASSOF, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.COMMENT, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.COMMENT, RDF.TYPE, (Value)RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.COMMENT, RDFS.DOMAIN, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.COMMENT, RDFS.RANGE, (Value)RDFS.LITERAL);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.COMMENT, RDFS.SUBPROPERTYOF, (Value)RDFS.COMMENT);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.DOMAIN, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.DOMAIN, RDF.TYPE, (Value)RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.DOMAIN, RDFS.DOMAIN, (Value)RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.DOMAIN, RDFS.RANGE, (Value)RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.DOMAIN, RDFS.SUBPROPERTYOF, (Value)RDFS.DOMAIN);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.ISDEFINEDBY, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.ISDEFINEDBY, RDF.TYPE, (Value)RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.ISDEFINEDBY, RDFS.DOMAIN, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.ISDEFINEDBY, RDFS.RANGE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.ISDEFINEDBY, RDFS.SUBPROPERTYOF, (Value)RDFS.SEEALSO);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.ISDEFINEDBY, RDFS.SUBPROPERTYOF, (Value)RDFS.ISDEFINEDBY);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.LABEL, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.LABEL, RDF.TYPE, (Value)RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.LABEL, RDFS.DOMAIN, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.LABEL, RDFS.RANGE, (Value)RDFS.LITERAL);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.LABEL, RDFS.SUBPROPERTYOF, (Value)RDFS.LABEL);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.MEMBER, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.MEMBER, RDF.TYPE, (Value)RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.MEMBER, RDFS.DOMAIN, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.MEMBER, RDFS.RANGE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.MEMBER, RDFS.SUBPROPERTYOF, (Value)RDFS.MEMBER);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.RANGE, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.RANGE, RDF.TYPE, (Value)RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.RANGE, RDFS.DOMAIN, (Value)RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.RANGE, RDFS.RANGE, (Value)RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.RANGE, RDFS.SUBPROPERTYOF, (Value)RDFS.RANGE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.SEEALSO, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.SEEALSO, RDF.TYPE, (Value)RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.SEEALSO, RDFS.DOMAIN, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.SEEALSO, RDFS.RANGE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.SEEALSO, RDFS.SUBPROPERTYOF, (Value)RDFS.SEEALSO);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.SUBCLASSOF, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.SUBCLASSOF, RDF.TYPE, (Value)RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.SUBCLASSOF, RDFS.DOMAIN, (Value)RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.SUBCLASSOF, RDFS.RANGE, (Value)RDFS.CLASS);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.SUBCLASSOF, RDFS.SUBPROPERTYOF, (Value)RDFS.SUBCLASSOF);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.SUBPROPERTYOF, RDF.TYPE, (Value)RDFS.RESOURCE);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.SUBPROPERTYOF, RDF.TYPE, (Value)RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.SUBPROPERTYOF, RDFS.DOMAIN, (Value)RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.SUBPROPERTYOF, RDFS.RANGE, (Value)RDF.PROPERTY);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
        statement = vf.createStatement((Resource)RDFS.SUBPROPERTYOF, RDFS.SUBPROPERTYOF, (Value)RDFS.SUBPROPERTYOF);
        this.processForSchemaCache(statement);
        this.addInferredStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
    }

    @Override
    public void rollback() throws SailException {
        super.rollback();
        if (this.sail.schema == null && this.sail.getSchemaSize() != this.originalSchemaSize) {
            this.sail.clearInferenceTables();
            this.sail.rolledBackAfterModifyingSchemaCache = true;
        }
        this.statementsRemoved = false;
        this.statementsRemoved = false;
        this.sail.releaseExclusiveWriteLock();
    }

    @Override
    public void begin() throws SailException {
        this.begin(null);
    }

    @Override
    public void begin(IsolationLevel level) throws SailException {
        IsolationLevel compatibleLevel;
        if (level == null) {
            level = this.sail.getDefaultIsolationLevel();
        }
        if ((compatibleLevel = IsolationLevels.getCompatibleIsolationLevel((IsolationLevel)level, this.sail.getSupportedIsolationLevels())) == null) {
            throw new UnknownSailTransactionStateException("Isolation level " + level + " not compatible with this Sail");
        }
        super.begin(compatibleLevel);
        if (this.sail.rolledBackAfterModifyingSchemaCache) {
            this.regenerateCacheAndInferenceMaps();
        }
        this.sail.rolledBackAfterModifyingSchemaCache = false;
        this.originalSchemaSize = this.sail.getSchemaSize();
    }

    @Override
    public void flushUpdates() throws SailException {
        if (this.statementsRemoved) {
            this.logger.debug("full recomputation needed, starting inferencing from scratch");
            this.clearInferred(new Resource[0]);
            super.flushUpdates();
            this.addAxiomStatements();
            super.flushUpdates();
            this.doInferencing();
            super.flushUpdates();
        } else if (this.statementsAdded) {
            super.flushUpdates();
            this.doInferencing();
        } else {
            super.flushUpdates();
        }
        this.statementsAdded = false;
        this.statementsRemoved = false;
    }

    @Override
    public void statementAdded(Statement st) {
        this.statementsAdded = true;
    }

    @Override
    public void statementRemoved(Statement st) {
        this.statementsRemoved = true;
    }
}

