/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import java.util.List;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.EmptySet;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.FunctionCall;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.sail.lucene.SearchQueryEvaluator;

public class DistanceQuerySpec
implements SearchQueryEvaluator {
    private FunctionCall distanceFunction;
    private Literal from;
    private IRI units;
    private final ValueExpr distanceExpr;
    private double distance;
    private String distanceVar;
    private StatementPattern geoStatement;
    private String subjectVar;
    private Var contextVar;
    private IRI geoProperty;
    private final String geoVar;
    private Filter filter;

    public DistanceQuerySpec(FunctionCall distanceFunction, ValueExpr distanceExpr, String distVar, Filter filter) {
        Literal dist;
        this.distanceFunction = distanceFunction;
        this.distanceExpr = distanceExpr;
        this.distanceVar = distVar;
        this.filter = filter;
        if (distanceFunction != null) {
            List args = distanceFunction.getArgs();
            this.from = DistanceQuerySpec.getLiteral((ValueExpr)args.get(0));
            this.geoVar = DistanceQuerySpec.getVarName((ValueExpr)args.get(1));
            this.units = DistanceQuerySpec.getURI((ValueExpr)args.get(2));
        } else {
            this.from = null;
            this.geoVar = null;
            this.units = null;
        }
        this.distance = distanceExpr != null ? ((dist = DistanceQuerySpec.getLiteral(distanceExpr)) != null ? dist.doubleValue() : Double.NaN) : Double.NaN;
    }

    public DistanceQuerySpec(Literal from, IRI units, double dist, String distVar, IRI geoProperty, String geoVar, String subjectVar, Var contextVar) {
        this.from = from;
        this.units = units;
        this.distance = dist;
        this.distanceVar = distVar;
        this.geoProperty = geoProperty;
        this.geoVar = geoVar;
        this.subjectVar = subjectVar;
        this.contextVar = contextVar;
        this.distanceFunction = null;
        this.distanceExpr = null;
        this.filter = null;
    }

    public void setFrom(Literal from) {
        this.from = from;
    }

    public Literal getFrom() {
        return this.from;
    }

    public void setUnits(IRI units) {
        this.units = units;
    }

    public IRI getUnits() {
        return this.units;
    }

    public void setDistance(double d) {
        this.distance = d;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistanceVar(String varName) {
        this.distanceVar = varName;
    }

    public String getDistanceVar() {
        return this.distanceVar;
    }

    public void setGeometryPattern(StatementPattern sp) {
        if (sp.getSubjectVar().hasValue()) {
            throw new IllegalArgumentException("Subject cannot be bound: " + sp);
        }
        if (!sp.getPredicateVar().hasValue()) {
            throw new IllegalArgumentException("Predicate must be bound: " + sp);
        }
        if (sp.getObjectVar().hasValue()) {
            throw new IllegalArgumentException("Object cannot be bound: " + sp);
        }
        if (!sp.getObjectVar().getName().equals(this.geoVar)) {
            throw new IllegalArgumentException("Object var name does not match geometry var name");
        }
        this.geoStatement = sp;
        this.subjectVar = sp.getSubjectVar().getName();
        this.contextVar = sp.getContextVar();
        this.geoProperty = (IRI)sp.getPredicateVar().getValue();
    }

    public String getSubjectVar() {
        return this.subjectVar;
    }

    public Var getContextVar() {
        return this.contextVar;
    }

    public IRI getGeoProperty() {
        return this.geoProperty;
    }

    public String getGeoVar() {
        return this.geoVar;
    }

    public void setDistanceFunctionCall(FunctionCall distanceFunction) {
        this.distanceFunction = distanceFunction;
    }

    public FunctionCall getDistanceFunctionCall() {
        return this.distanceFunction;
    }

    public ValueExpr getDistanceExpr() {
        return this.distanceExpr;
    }

    public void setFilter(Filter f) {
        this.filter = f;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public QueryModelNode getParentQueryModelNode() {
        return this.filter;
    }

    @Override
    public void updateQueryModelNodes(boolean hasResult) {
        SingletonSet replacementNode = hasResult ? new SingletonSet() : new EmptySet();
        this.geoStatement.replaceWith((QueryModelNode)replacementNode);
        if (hasResult) {
            this.filter.replaceWith((QueryModelNode)this.filter.getArg());
        } else {
            this.filter.replaceWith((QueryModelNode)new EmptySet());
        }
        QueryModelNode functionParent = this.distanceFunction.getParentNode();
        if (functionParent instanceof ExtensionElem) {
            Extension extension = (Extension)functionParent.getParentNode();
            List elements = extension.getElements();
            if (elements.size() > 1) {
                elements.remove(functionParent);
            } else {
                extension.replaceWith((QueryModelNode)extension.getArg());
            }
        }
    }

    public boolean isEvaluable() {
        return this.getFrom() != null && !Double.isNaN(this.distance) && this.getUnits() != null && this.geoProperty != null;
    }

    static Literal getLiteral(ValueExpr v) {
        Value value = DistanceQuerySpec.getValue(v);
        if (value instanceof Literal) {
            return (Literal)value;
        }
        return null;
    }

    static IRI getURI(ValueExpr v) {
        Value value = DistanceQuerySpec.getValue(v);
        if (value instanceof IRI) {
            return (IRI)value;
        }
        return null;
    }

    static Value getValue(ValueExpr v) {
        Value value = null;
        if (v instanceof ValueConstant) {
            value = ((ValueConstant)v).getValue();
        } else if (v instanceof Var) {
            value = ((Var)v).getValue();
        }
        return value;
    }

    static String getVarName(ValueExpr v) {
        Var var;
        if (v instanceof Var && !(var = (Var)v).isConstant()) {
            return var.getName();
        }
        return null;
    }
}

