/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin.function;

import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.SPIN;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryPreparer;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.TupleFunction;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.spin.SpinParser;
import org.eclipse.rdf4j.spin.function.AbstractSpinFunction;

public class ConstructTupleFunction
extends AbstractSpinFunction
implements TupleFunction {
    private SpinParser parser;

    public ConstructTupleFunction() {
        super(SPIN.CONSTRUCT_PROPERTY.stringValue());
    }

    public ConstructTupleFunction(SpinParser parser) {
        this();
        this.parser = parser;
    }

    public SpinParser getSpinParser() {
        return this.parser;
    }

    public void setSpinParser(SpinParser parser) {
        this.parser = parser;
    }

    @Override
    public CloseableIteration<? extends List<? extends Value>, QueryEvaluationException> evaluate(ValueFactory valueFactory, Value ... args) throws QueryEvaluationException {
        QueryPreparer qp = this.getCurrentQueryPreparer();
        if (args.length == 0 || !(args[0] instanceof Resource)) {
            throw new QueryEvaluationException("First argument must be a resource");
        }
        if (args.length % 2 == 0) {
            throw new QueryEvaluationException("Old number of arguments required");
        }
        try {
            ParsedGraphQuery graphQuery = this.parser.parseConstructQuery((Resource)args[0], qp.getTripleSource());
            GraphQuery queryOp = qp.prepare(graphQuery);
            ConstructTupleFunction.addBindings((Query)queryOp, args);
            GraphQueryResult queryResult = queryOp.evaluate();
            return new GraphQueryResultIteration(queryResult);
        }
        catch (QueryEvaluationException e) {
            throw e;
        }
        catch (RDF4JException e) {
            throw new ValueExprEvaluationException(e);
        }
    }

    static class GraphQueryResultIteration
    extends AbstractCloseableIteration<List<Value>, QueryEvaluationException> {
        private final GraphQueryResult queryResult;

        GraphQueryResultIteration(GraphQueryResult queryResult) {
            this.queryResult = queryResult;
        }

        public boolean hasNext() throws QueryEvaluationException {
            if (this.isClosed()) {
                return false;
            }
            boolean result = this.queryResult.hasNext();
            if (!result) {
                this.close();
            }
            return result;
        }

        public List<Value> next() throws QueryEvaluationException {
            if (this.isClosed()) {
                throw new NoSuchElementException("The iteration has been closed.");
            }
            try {
                Statement stmt = (Statement)this.queryResult.next();
                Resource ctx = stmt.getContext();
                if (ctx != null) {
                    return Arrays.asList(stmt.getSubject(), stmt.getPredicate(), stmt.getObject(), ctx);
                }
                return Arrays.asList(stmt.getSubject(), stmt.getPredicate(), stmt.getObject());
            }
            catch (NoSuchElementException e) {
                this.close();
                throw e;
            }
        }

        public void remove() throws QueryEvaluationException {
            if (this.isClosed()) {
                throw new IllegalStateException("The iteration has been closed.");
            }
            try {
                this.queryResult.remove();
            }
            catch (IllegalStateException e) {
                this.close();
                throw e;
            }
        }

        public void handleClose() throws QueryEvaluationException {
            try {
                super.handleClose();
            }
            finally {
                this.queryResult.close();
            }
        }
    }
}

