/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchResultViewEntry;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;

class RemovePotentialMatchesAction
extends Action {
    private IWorkbenchSite fSite;

    public RemovePotentialMatchesAction(IWorkbenchSite site) {
        this.fSite = site;
        if (this.usePluralLabel()) {
            this.setText(SearchMessages.RemovePotentialMatchesAction_removePotentialMatches_text);
            this.setToolTipText(SearchMessages.RemovePotentialMatchesAction_removePotentialMatches_tooltip);
        } else {
            this.setText(SearchMessages.RemovePotentialMatchesAction_removePotentialMatch_text);
            this.setToolTipText(SearchMessages.RemovePotentialMatchesAction_removePotentialMatch_tooltip);
        }
    }

    public void run() {
        IMarker[] markers = this.getMarkers();
        if (markers != null) {
            try {
                SearchPlugin.getWorkspace().deleteMarkers(markers);
            }
            catch (CoreException ex) {
                ExceptionHandler.handle(ex, SearchMessages.Search_Error_deleteMarkers_title, SearchMessages.Search_Error_deleteMarkers_message);
            }
        } else {
            String title = SearchMessages.RemovePotentialMatchesAction_dialog_title;
            String message = SearchMessages.RemovePotentialMatchesAction_dialog_message;
            MessageDialog.openInformation((Shell)this.fSite.getShell(), (String)title, (String)message);
        }
        this.setEnabled(false);
    }

    private IMarker[] getMarkers() {
        ISelection s = this.fSite.getSelectionProvider().getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        int size = selection.size();
        if (size <= 0) {
            return null;
        }
        ArrayList<IMarker> markers = new ArrayList<IMarker>(size * 3);
        Iterator iter = selection.iterator();
        int i = 0;
        while (iter.hasNext()) {
            SearchResultViewEntry entry = (SearchResultViewEntry)iter.next();
            Iterator entryIter = entry.getMarkers().iterator();
            while (entryIter.hasNext()) {
                IMarker marker = (IMarker)entryIter.next();
                if (!marker.getAttribute("potentialMatch", false)) continue;
                markers.add(marker);
            }
            ++i;
        }
        return markers.toArray(new IMarker[markers.size()]);
    }

    private boolean usePluralLabel() {
        ISelection s = this.fSite.getSelectionProvider().getSelection();
        if (!(s instanceof IStructuredSelection) || s.isEmpty()) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        int size = selection.size();
        if (size <= 0) {
            return false;
        }
        int markerCount = 0;
        Iterator iter = selection.iterator();
        int i = 0;
        while (iter.hasNext()) {
            SearchResultViewEntry entry = (SearchResultViewEntry)iter.next();
            Iterator entryIter = entry.getMarkers().iterator();
            while (entryIter.hasNext()) {
                IMarker marker = (IMarker)entryIter.next();
                if (marker.getAttribute("potentialMatch", false)) {
                    ++markerCount;
                }
                if (markerCount <= 1) continue;
                return true;
            }
            ++i;
        }
        return false;
    }
}

