/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess;

import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.nativeaccess.AbstractNativeAccess;
import org.elasticsearch.nativeaccess.LinuxNativeAccess;
import org.elasticsearch.nativeaccess.MacNativeAccess;
import org.elasticsearch.nativeaccess.NativeAccess;
import org.elasticsearch.nativeaccess.NoopNativeAccess;
import org.elasticsearch.nativeaccess.WindowsNativeAccess;
import org.elasticsearch.nativeaccess.lib.NativeLibraryProvider;

class NativeAccessHolder {
    protected static final Logger logger = LogManager.getLogger(NativeAccess.class);
    static final NativeAccess INSTANCE;

    NativeAccessHolder() {
    }

    static {
        NativeLibraryProvider libProvider = NativeLibraryProvider.instance();
        String os = System.getProperty("os.name");
        AbstractNativeAccess inst = null;
        try {
            if (os.startsWith("Linux")) {
                inst = new LinuxNativeAccess(libProvider);
            } else if (os.startsWith("Mac OS")) {
                inst = new MacNativeAccess(libProvider);
            } else if (os.startsWith("Windows")) {
                inst = new WindowsNativeAccess(libProvider);
            } else {
                logger.warn("Unsupported OS [" + os + "]. Native methods will be disabled.");
            }
        }
        catch (LinkageError e) {
            logger.warn("Unable to load native provider. Native methods will be disabled.", (Throwable)e);
        }
        if (inst == null) {
            inst = new NoopNativeAccess();
        } else {
            logger.info("Using [" + libProvider.getName() + "] native provider and native methods for [" + inst.getName() + "]");
        }
        INSTANCE = inst;
    }
}

