/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess.jdk;

import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.VarHandle;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class MemorySegmentUtil {
    static String getString(MemorySegment segment, long offset) {
        return segment.getUtf8String(offset);
    }

    static MemorySegment allocateString(Arena arena, String s) {
        return arena.allocateUtf8String(s);
    }

    static VarHandle varHandleWithoutOffset(MemoryLayout layout, MemoryLayout.PathElement element) {
        return layout.varHandle(element);
    }

    private MemorySegmentUtil() {
    }
}

