/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess;

import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.nativeaccess.Systemd;
import org.elasticsearch.nativeaccess.lib.Kernel32Library;

public class WindowsFunctions {
    private static final Logger logger = LogManager.getLogger(Systemd.class);
    private final Kernel32Library kernel;

    WindowsFunctions(Kernel32Library kernel) {
        this.kernel = kernel;
    }

    public String getShortPathName(String path) {
        String longPath = "\\\\?\\" + path;
        int length = this.kernel.GetShortPathNameW(longPath, null, 0);
        if (length == 0) {
            logger.warn("failed to get short path name: {}", new Object[]{this.kernel.GetLastError()});
            return path;
        }
        char[] shortPath = new char[length];
        if (this.kernel.GetShortPathNameW(longPath, shortPath, length) > 0) {
            assert (shortPath[length - 1] == '\u0000');
            return new String(shortPath, 0, length - 1);
        }
        logger.warn("failed to get short path name: {}", new Object[]{this.kernel.GetLastError()});
        return path;
    }

    public boolean addConsoleCtrlHandler(ConsoleCtrlHandler handler) {
        return this.kernel.SetConsoleCtrlHandler(dwCtrlType -> {
            if (logger.isDebugEnabled()) {
                logger.debug("console control handler received event [{}]", new Object[]{dwCtrlType});
            }
            return handler.handle(dwCtrlType);
        }, true);
    }

    public static interface ConsoleCtrlHandler {
        public static final int CTRL_CLOSE_EVENT = 2;

        public boolean handle(int var1);
    }
}

