/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nio;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.elasticsearch.nio.FlushOperation;
import org.elasticsearch.nio.FlushReadyWrite;
import org.elasticsearch.nio.ReadWriteHandler;
import org.elasticsearch.nio.SocketChannelContext;
import org.elasticsearch.nio.WriteOperation;

public abstract class BytesWriteHandler
implements ReadWriteHandler {
    private static final List<FlushOperation> EMPTY_LIST = Collections.emptyList();

    @Override
    public WriteOperation createWriteOperation(SocketChannelContext context, Object message, BiConsumer<Void, Exception> listener) {
        assert (message instanceof ByteBuffer[]) : "This channel only supports messages that are of type: " + ByteBuffer[].class + ". Found type: " + message.getClass() + ".";
        return new FlushReadyWrite(context, (ByteBuffer[])message, listener);
    }

    @Override
    public List<FlushOperation> writeToBytes(WriteOperation writeOperation) {
        assert (writeOperation instanceof FlushReadyWrite) : "Write operation must be flush ready";
        return Collections.singletonList((FlushReadyWrite)writeOperation);
    }

    @Override
    public List<FlushOperation> pollFlushOperations() {
        return EMPTY_LIST;
    }

    @Override
    public void close() {
    }
}

