/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nio;

import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;

public final class SelectionKeyUtils {
    private SelectionKeyUtils() {
    }

    public static void setWriteInterested(SelectionKey selectionKey) throws CancelledKeyException {
        selectionKey.interestOps(selectionKey.interestOps() | 4);
    }

    public static void removeWriteInterested(SelectionKey selectionKey) throws CancelledKeyException {
        selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFB);
    }

    public static void setConnectAndReadInterested(SelectionKey selectionKey) throws CancelledKeyException {
        selectionKey.interestOps(selectionKey.interestOps() | 8 | 1);
    }

    public static void setConnectReadAndWriteInterested(SelectionKey selectionKey) throws CancelledKeyException {
        selectionKey.interestOps(selectionKey.interestOps() | 8 | 1 | 4);
    }

    public static void removeConnectInterested(SelectionKey selectionKey) throws CancelledKeyException {
        selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFF7);
    }

    public static void setAcceptInterested(SelectionKey selectionKey) throws CancelledKeyException {
        selectionKey.interestOps(selectionKey.interestOps() | 0x10);
    }

    public static boolean isWriteInterested(SelectionKey selectionKey) throws CancelledKeyException {
        return (selectionKey.interestOps() & 4) != 0;
    }
}

