/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.boot.web.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.services.FF4jServices;
import org.ff4j.services.domain.AuthorizationsManagerApiBean;
import org.ff4j.services.domain.FF4jStatusApiBean;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"FF4J"}, description="The API for global status of FF4J")
@RestController
@RequestMapping(value={"/api/ff4j"})
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0017J.\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0001\u0010\n\u001a\u00020\u000b2\u0014\b\u0001\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\rH\u0017J\b\u0010\u000e\u001a\u00020\u000fH\u0017J\b\u0010\u0010\u001a\u00020\u0011H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/ff4j/spring/boot/web/api/resources/FF4jResource;", "", "ff4JServices", "Lorg/ff4j/services/FF4jServices;", "(Lorg/ff4j/services/FF4jServices;)V", "getFf4JServices", "()Lorg/ff4j/services/FF4jServices;", "check", "Lorg/springframework/http/ResponseEntity;", "", "featureUID", "", "formParams", "Lorg/springframework/util/MultiValueMap;", "getSecurityInfo", "Lorg/ff4j/services/domain/AuthorizationsManagerApiBean;", "getStatus", "Lorg/ff4j/services/domain/FF4jStatusApiBean;", "ff4j-spring-boot-web-api"})
public class FF4jResource {
    @NotNull
    private final FF4jServices ff4JServices;

    @ApiOperation(value="Gets ff4j status overview", notes="Gets information related to Monitoring, Security, Cache and Store")
    @ApiResponses(value={@ApiResponse(code=200, response=FF4jStatusApiBean.class, message="Success, return status of ff4j instance")})
    @GetMapping(produces={"application/json"})
    @NotNull
    public FF4jStatusApiBean getStatus() {
        return this.getFf4JServices().getStatus();
    }

    @ApiOperation(value="Gets Security information (permissions manager)", notes="Security is implemented through dedicated AuthorizationsManager but it's not mandatory")
    @ApiResponses(value={@ApiResponse(code=200, response=AuthorizationsManagerApiBean.class, message="Status of current ff4j security bean"), @ApiResponse(code=404, message="no security has been defined")})
    @GetMapping(produces={"application/json"}, value={"/security"})
    @NotNull
    public AuthorizationsManagerApiBean getSecurityInfo() {
        return this.getFf4JServices().getSecurityInfo();
    }

    @ApiOperation(value="Simple check feature toggle", response=boolean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="If feature is flipped"), @ApiResponse(code=404, message="Feature not found")})
    @GetMapping(value={"/check/{uid}"})
    @NotNull
    public ResponseEntity<Boolean> check(@PathVariable(value="uid") @NotNull String featureUID) {
        Intrinsics.checkParameterIsNotNull((Object)featureUID, (String)"featureUID");
        boolean status = this.getFf4JServices().check(featureUID);
        return new ResponseEntity((Object)status, HttpStatus.OK);
    }

    @ApiOperation(value="Advanced check feature toggle (parametrized)", response=boolean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="If feature is flipped"), @ApiResponse(code=400, message="Invalid parameter"), @ApiResponse(code=404, message="Feature not found")})
    @PostMapping(consumes={"application/x-www-form-urlencoded"}, value={"/check/{uid}"})
    @NotNull
    public ResponseEntity<Boolean> check(@PathVariable(value="uid") @NotNull String featureUID, @RequestParam @NotNull MultiValueMap<String, String> formParams) {
        Intrinsics.checkParameterIsNotNull((Object)featureUID, (String)"featureUID");
        Intrinsics.checkParameterIsNotNull(formParams, (String)"formParams");
        Map map = formParams.toSingleValueMap();
        FF4jServices fF4jServices = this.getFf4JServices();
        Map map2 = map;
        Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"map");
        boolean status = fF4jServices.check(featureUID, map2);
        return new ResponseEntity((Object)status, HttpStatus.OK);
    }

    @NotNull
    public FF4jServices getFf4JServices() {
        return this.ff4JServices;
    }

    public FF4jResource(@Autowired @NotNull FF4jServices ff4JServices) {
        Intrinsics.checkParameterIsNotNull((Object)ff4JServices, (String)"ff4JServices");
        this.ff4JServices = ff4JServices;
    }
}

