/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.springjdbc.store;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.ff4j.core.Feature;
import org.ff4j.exception.FeatureAlreadyExistException;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.exception.GroupNotFoundException;
import org.ff4j.property.Property;
import org.ff4j.springjdbc.store.rowmapper.CustomPropertyRowMapper;
import org.ff4j.springjdbc.store.rowmapper.FeatureRowMapper;
import org.ff4j.springjdbc.store.rowmapper.RoleRowMapper;
import org.ff4j.store.AbstractFeatureStore;
import org.ff4j.store.JdbcQueryBuilder;
import org.ff4j.utils.JdbcUtils;
import org.ff4j.utils.MappingUtil;
import org.ff4j.utils.Util;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class FeatureStoreSpringJdbc
extends AbstractFeatureStore {
    private static final FeatureRowMapper FMAPPER = new FeatureRowMapper();
    private static final CustomPropertyRowMapper PMAPPER = new CustomPropertyRowMapper();
    public static final String FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY = "Feature identifier cannot be null nor empty";
    public static final String GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY = "Groupname cannot be null nor empty";
    private DataSource dataSource;
    private JdbcTemplate jdbcTemplate;
    private JdbcQueryBuilder queryBuilder;

    public FeatureStoreSpringJdbc() {
    }

    public FeatureStoreSpringJdbc(DataSource ds) {
        this.dataSource = ds;
    }

    public void enable(String uid) {
        Util.assertHasLength((String[])new String[]{uid});
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.getJdbcTemplate().update(this.getQueryBuilder().enableFeature(), new Object[]{uid});
    }

    public void disable(String uid) {
        Util.assertHasLength((String[])new String[]{uid});
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.getJdbcTemplate().update(this.getQueryBuilder().disableFeature(), new Object[]{uid});
    }

    public boolean exist(String uid) {
        Util.assertHasLength((String[])new String[]{uid});
        return 1 == (Integer)this.getJdbcTemplate().queryForObject(this.getQueryBuilder().existFeature(), Integer.class, new Object[]{uid});
    }

    public Feature read(String uid) {
        Util.assertHasLength((String[])new String[]{uid});
        try {
            Feature feature = (Feature)this.getJdbcTemplate().queryForObject(this.getQueryBuilder().getFeature(), (RowMapper)FMAPPER, new Object[]{uid});
            this.readProperties(feature);
            this.readPermissions(feature);
            return feature;
        }
        catch (EmptyResultDataAccessException ex) {
            throw new FeatureNotFoundException(uid, (Throwable)ex);
        }
    }

    private void readProperties(Feature fp) {
        List listOfProps = this.getJdbcTemplate().query(this.getQueryBuilder().getFeatureProperties(), (RowMapper)PMAPPER, new Object[]{fp.getUid()});
        for (Property ap : listOfProps) {
            fp.getCustomProperties().put(ap.getName(), ap);
        }
    }

    private void readPermissions(Feature fp) {
        fp.getPermissions().addAll(this.getJdbcTemplate().query(this.getQueryBuilder().getRoles(), (RowMapper)new SingleColumnRowMapper(), new Object[]{fp.getUid()}));
    }

    @Transactional
    public void create(Feature fp) {
        Util.assertNotNull((Object[])new Object[]{fp});
        if (this.exist(fp.getUid())) {
            throw new FeatureAlreadyExistException(fp.getUid());
        }
        this.createCoreFeature(fp);
        this.createPermissions(fp);
        this.createProperties(fp);
    }

    private void createCoreFeature(Feature fp) {
        String strategyColumn = null;
        String expressionColumn = null;
        if (fp.getFlippingStrategy() != null) {
            strategyColumn = fp.getFlippingStrategy().getClass().getName();
            expressionColumn = MappingUtil.fromMap((Map)fp.getFlippingStrategy().getInitParams());
        }
        this.getJdbcTemplate().update(this.getQueryBuilder().createFeature(), new Object[]{fp.getUid(), fp.isEnable() ? 1 : 0, fp.getDescription(), strategyColumn, expressionColumn, fp.getGroup()});
    }

    private void createPermissions(Feature fp) {
        if (fp.getPermissions() != null) {
            this.getJdbcTemplate().update(this.getQueryBuilder().deleteRoles(), new Object[]{fp.getUid()});
            for (String role : fp.getPermissions()) {
                this.getJdbcTemplate().update(this.getQueryBuilder().addRoleToFeature(), new Object[]{fp.getUid(), role});
            }
        }
    }

    private void createProperties(Feature fp) {
        if (fp.getCustomProperties() != null) {
            this.getJdbcTemplate().update(this.getQueryBuilder().deleteAllFeatureCustomProperties(), new Object[]{fp.getUid()});
            for (String propertyName : fp.getCustomProperties().keySet()) {
                Property ap = (Property)fp.getCustomProperties().get(propertyName);
                String fixedValues = null;
                if (ap.getFixedValues() != null && ap.getFixedValues().size() > 0) {
                    fixedValues = ap.getFixedValues().toString();
                    fixedValues = fixedValues.substring(1, fixedValues.length() - 1);
                }
                this.getJdbcTemplate().update(this.getQueryBuilder().createFeatureProperty(), new Object[]{ap.getName(), ap.getType(), ap.asString(), ap.getDescription(), fixedValues, fp.getUid()});
            }
        }
    }

    @Transactional
    public void delete(String uid) {
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.deletePermissions(uid);
        this.deleteProperties(uid);
        this.deleteCoreFeature(uid);
    }

    private void deletePermissions(String featureId) {
        this.getJdbcTemplate().update(this.getQueryBuilder().deleteRoles(), new Object[]{featureId});
    }

    private void deleteProperties(String featureId) {
        this.getJdbcTemplate().update(this.getQueryBuilder().deleteAllFeatureCustomProperties(), new Object[]{featureId});
    }

    private void deleteCoreFeature(String featureId) {
        this.getJdbcTemplate().update(this.getQueryBuilder().deleteFeature(), new Object[]{featureId});
    }

    @Transactional
    public void grantRoleOnFeature(String uid, String roleName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException(FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (roleName == null || roleName.isEmpty()) {
            throw new IllegalArgumentException("roleName cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.getJdbcTemplate().update(this.getQueryBuilder().addRoleToFeature(), new Object[]{uid, roleName});
    }

    @Transactional
    public void removeRoleFromFeature(String uid, String roleName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException(FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (roleName == null || roleName.isEmpty()) {
            throw new IllegalArgumentException("roleName cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.getJdbcTemplate().update(this.getQueryBuilder().deleteFeatureRole(), new Object[]{uid, roleName});
    }

    @Transactional
    public void enableGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException(GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        this.getJdbcTemplate().update(this.getQueryBuilder().enableGroup(), new Object[]{groupName});
    }

    @Transactional
    public void disableGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException(GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        this.getJdbcTemplate().update(this.getQueryBuilder().disableGroup(), new Object[]{groupName});
    }

    public boolean existGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException(GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY);
        }
        int count = (Integer)this.getJdbcTemplate().queryForObject(this.getQueryBuilder().existGroup(), Integer.class, new Object[]{groupName});
        return count > 0;
    }

    public Map<String, Feature> readGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException(GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        LinkedHashMap<String, Feature> mapFP = new LinkedHashMap<String, Feature>();
        List lFp = this.getJdbcTemplate().query(this.getQueryBuilder().getFeatureOfGroup(), (RowMapper)FMAPPER, new Object[]{groupName});
        for (Feature flipPoint : lFp) {
            mapFP.put(flipPoint.getUid(), flipPoint);
        }
        return mapFP;
    }

    @Transactional
    public void addToGroup(String uid, String groupName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException(FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException(GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.getJdbcTemplate().update(this.getQueryBuilder().addFeatureToGroup(), new Object[]{groupName, uid});
    }

    @Transactional
    public void removeFromGroup(String uid, String groupName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException(FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException(GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        this.getJdbcTemplate().update(this.getQueryBuilder().addFeatureToGroup(), new Object[]{"", uid});
    }

    public Map<String, Feature> readAll() {
        LinkedHashMap<String, Feature> mapFP = new LinkedHashMap<String, Feature>();
        List lFp = this.getJdbcTemplate().query(this.getQueryBuilder().getAllFeatures(), (RowMapper)FMAPPER);
        for (Feature flipPoint : lFp) {
            mapFP.put(flipPoint.getUid(), flipPoint);
        }
        RoleRowMapper rrm = new RoleRowMapper();
        this.getJdbcTemplate().query(this.getQueryBuilder().getAllRoles(), (RowMapper)rrm);
        Map<String, Set<String>> roles = rrm.getRoles();
        for (Map.Entry<String, Set<String>> featId : roles.entrySet()) {
            if (!mapFP.containsKey(featId.getKey())) continue;
            mapFP.get(featId.getKey()).getPermissions().addAll((Collection)featId.getValue());
        }
        return mapFP;
    }

    public Set<String> readAllGroups() {
        HashSet<String> setOfGroup = new HashSet<String>();
        setOfGroup.addAll(this.getJdbcTemplate().query(this.getQueryBuilder().getAllGroups(), (RowMapper)new SingleColumnRowMapper()));
        setOfGroup.remove(null);
        setOfGroup.remove("");
        return setOfGroup;
    }

    @Transactional
    public void update(Feature newFeature) {
        Util.assertNotNull((Object[])new Object[]{newFeature});
        this.delete(newFeature.getUid());
        this.create(newFeature);
    }

    @Transactional
    public void createSchema() {
        JdbcQueryBuilder qb = this.getQueryBuilder();
        String dbSchema = this.queryBuilder.getDbSchema();
        if (!JdbcUtils.isTableExist((DataSource)this.dataSource, (String)qb.getTableNameFeatures(), (String)dbSchema)) {
            this.getJdbcTemplate().update(qb.sqlCreateTableFeatures());
        }
        if (!JdbcUtils.isTableExist((DataSource)this.dataSource, (String)qb.getTableNameCustomProperties(), (String)dbSchema)) {
            this.getJdbcTemplate().update(qb.sqlCreateTableCustomProperties());
        }
        if (!JdbcUtils.isTableExist((DataSource)this.dataSource, (String)qb.getTableNameRoles(), (String)dbSchema)) {
            this.getJdbcTemplate().update(qb.sqlCreateTableRoles());
        }
    }

    @Transactional
    public void clear() {
        this.getJdbcTemplate().update(this.getQueryBuilder().deleteAllRoles());
        this.getJdbcTemplate().update(this.getQueryBuilder().deleteAllCustomProperties());
        this.getJdbcTemplate().update(this.getQueryBuilder().deleteAllFeatures());
    }

    @Required
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public JdbcTemplate getJdbcTemplate() {
        if (this.jdbcTemplate == null) {
            if (this.dataSource == null) {
                throw new IllegalStateException("ff4j-jdbc: DatabaseStore has not been properly initialized, datasource is null");
            }
            this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        }
        return this.jdbcTemplate;
    }

    public JdbcQueryBuilder getQueryBuilder() {
        if (this.queryBuilder == null) {
            this.queryBuilder = new JdbcQueryBuilder();
        }
        return this.queryBuilder;
    }

    public void setQueryBuilder(JdbcQueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }
}

