/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.springjdbc.store.rowmapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.ff4j.core.Feature;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.utils.MappingUtil;
import org.springframework.jdbc.core.RowMapper;

public class FeatureRowMapper
implements RowMapper<Feature> {
    public Feature mapRow(ResultSet rs, int rowNum) throws SQLException {
        String featUid = rs.getString("FEAT_UID");
        Feature f = new Feature(featUid, rs.getInt("ENABLE") > 0);
        f.setDescription(rs.getString("DESCRIPTION"));
        f.setGroup(rs.getString("GROUPNAME"));
        String strategy = rs.getString("STRATEGY");
        if (strategy != null && !"".equals(strategy)) {
            Map initParams = MappingUtil.toMap((String)rs.getString("EXPRESSION"));
            FlippingStrategy flipStrategy = MappingUtil.instanceFlippingStrategy((String)featUid, (String)strategy, (Map)initParams);
            f.setFlippingStrategy(flipStrategy);
        }
        return f;
    }
}

