/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api;

import com.sun.jersey.api.container.filter.LoggingFilter;
import com.sun.jersey.api.core.PackagesResourceConfig;
import com.sun.jersey.spi.inject.SingletonTypeInjectableProvider;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import java.util.Set;
import javax.ws.rs.core.Context;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.ff4j.FF4j;
import org.ff4j.web.ApiConfig;
import org.ff4j.web.api.FF4jJacksonMapper;
import org.ff4j.web.api.FF4jSwaggerConfiguration;
import org.ff4j.web.api.resources.FF4jResource;
import org.ff4j.web.api.security.FF4jRolesResourceFilterFactory;
import org.ff4j.web.api.security.FF4jSecurityContextFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FF4JApiApplication
extends PackagesResourceConfig {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public FF4JApiApplication() {
        super(new String[]{FF4jResource.class.getPackage().getName()});
        this.log.info("  __  __ _  _   _ ");
        this.log.info(" / _|/ _| || | (_)");
        this.log.info("| |_| |_| || |_| |");
        this.log.info("|  _|  _|__   _| |");
        this.log.info("|_| |_|    |_|_/ |");
        this.log.info("             |__/   WEB API Initialization...");
        this.log.info(" ");
        ApiConfig conf = this.getApiConfig();
        FF4jSecurityContextFilter.setSecurityConfig(conf);
        FF4jRolesResourceFilterFactory.setApiConfig(conf);
        this.getSingletons().add(new FF4jInjectableProvider(conf.getFF4j()));
        this.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        this.getSingletons().add(new JacksonJsonProvider());
        this.getSingletons().add(new FF4jJacksonMapper());
        if (conf.isAutorize()) {
            this.getProperties().put("com.sun.jersey.spi.container.ResourceFilters", FF4jRolesResourceFilterFactory.class.getCanonicalName());
            this.log.info("ff4j webApi security has been set up with both authentication and authorization");
        } else if (conf.isAuthenticate()) {
            StringBuilder filters = new StringBuilder();
            filters.append(FF4jSecurityContextFilter.class.getCanonicalName());
            if (conf.isLog()) {
                filters.append(";" + LoggingFilter.class.getCanonicalName());
            }
            this.getProperties().put("com.sun.jersey.spi.container.ContainerRequestFilters", filters.toString());
            this.log.info("ff4j webApi security has been set up with authentication only");
        } else {
            this.log.info("ff4j webApi security has been set up with no security");
        }
        if (conf.isDocumentation()) {
            BeanConfig beanConfig = FF4jSwaggerConfiguration.getBeanConfig();
            beanConfig.setVersion(conf.getVersion());
            beanConfig.setSchemes(new String[]{"http"});
            beanConfig.setHost(conf.getHost() + ":" + conf.getPort());
            beanConfig.setBasePath("/" + conf.getWebContext() + "/api");
            beanConfig.setScan(true);
            this.getSingletons().add(ApiListingResource.class);
            this.getSingletons().add(SwaggerSerializers.class);
        }
    }

    protected abstract ApiConfig getApiConfig();

    public Set<Class<?>> getClasses() {
        Set classes = super.getClasses();
        classes.add(ApiListingResource.class);
        classes.add(SwaggerSerializers.class);
        return classes;
    }

    public static class FF4jInjectableProvider
    extends SingletonTypeInjectableProvider<Context, FF4j> {
        public FF4jInjectableProvider(FF4j ff4j) {
            super(FF4j.class, (Object)ff4j);
        }
    }
}

