/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api.security;

import com.sun.jersey.core.util.Base64;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ResourceFilter;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.ff4j.web.ApiConfig;
import org.ff4j.web.api.security.FF4jSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FF4jSecurityContextFilter
implements ContainerRequestFilter,
ResourceFilter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static ApiConfig securityConfig = null;

    public ContainerRequest filter(ContainerRequest containerRequest) throws WebApplicationException {
        String method = containerRequest.getMethod();
        String path = containerRequest.getPath(true);
        this.log.debug("Entering security filter for <" + path + ">");
        if (method.equals("GET") && (path.equals("application.wadl") || path.equals("application.wadl/xsd0.xsd"))) {
            this.log.info("Accessing schema and wadl ok");
            return containerRequest;
        }
        String auth = containerRequest.getHeaderValue("Authorization");
        if (auth == null) {
            this.handleUnAuthorized("<p>'authorization' parameter is required in header  for authentication (HTTP-Basic or ApiKey)</p>");
        }
        if (auth.contains("apiKey")) {
            auth = auth.replaceFirst("apiKey=", "");
            if (!securityConfig.getApiKeys().contains(auth)) {
                this.handleUnAuthorized("The api key provided '" + auth + "' is invalid ");
            }
            Set perms = (Set)securityConfig.getPermissions().get(auth);
            FF4jSecurityContext sc = new FF4jSecurityContext(auth, "apiKey", perms);
            containerRequest.setSecurityContext((SecurityContext)sc);
            this.log.info("Client successfully logged with an ApiKey");
            return containerRequest;
        }
        if (auth.toUpperCase().contains("BASIC")) {
            String expectedPassword;
            byte[] decodedBytes = Base64.decode((String)auth.replaceFirst("[B|b]asic ", ""));
            String[] lap = new String(decodedBytes).split(":", 2);
            if (lap == null || lap.length != 2) {
                this.handleUnAuthorized("Invalid BASIC Token, cannot parse");
            }
            if ((expectedPassword = (String)securityConfig.getUsers().get(lap[0])) == null || !lap[1].equals(expectedPassword)) {
                this.handleUnAuthorized("<p>Invalid username or password.</p>");
            }
            Set perms = (Set)securityConfig.getPermissions().get(lap[0]);
            FF4jSecurityContext sc = new FF4jSecurityContext(lap[0], "BASIC", perms);
            containerRequest.setSecurityContext((SecurityContext)sc);
            this.log.info("Client successfully logged with a user/pasword pair ");
            return containerRequest;
        }
        this.handleUnAuthorized("Cannot parse authorisation header attribute, valid are basic and apiKey");
        return null;
    }

    private void handleUnAuthorized(String message) {
        StringBuilder msg = new StringBuilder("<p style=\"color:#880000\">");
        msg.append("<H1>ERROR HTTP 401 : Unauthorized</H1>");
        msg.append("<p>" + message + "</p>");
        this.log.error("Authentication error :" + message);
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)msg.toString()).type(MediaType.TEXT_HTML_TYPE).build());
    }

    public ContainerRequestFilter getRequestFilter() {
        return this;
    }

    public ContainerResponseFilter getResponseFilter() {
        return null;
    }

    public static ApiConfig getSecurityConfig() {
        return securityConfig;
    }

    public static void setSecurityConfig(ApiConfig securityConfig) {
        FF4jSecurityContextFilter.securityConfig = securityConfig;
    }
}

