/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.jersey1.store;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.ff4j.core.Feature;
import org.ff4j.exception.FeatureAccessException;
import org.ff4j.exception.FeatureAlreadyExistException;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.exception.GroupNotFoundException;
import org.ff4j.store.AbstractFeatureStore;
import org.ff4j.utils.Util;
import org.ff4j.utils.json.FeatureJsonParser;
import org.ff4j.web.api.resources.domain.FeatureApiBean;
import org.ff4j.web.api.resources.domain.GroupDescApiBean;
import org.ff4j.web.api.security.ClientHttpJersey1Utils;

public class FeatureStoreHttp
extends AbstractFeatureStore {
    private static final String OCCURED = " occured.";
    private static final String GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY = "Groupname cannot be null nor empty";
    private static final String CANNOT_GRANT_ROLE_ON_FEATURE_AN_HTTP_ERROR = "Cannot grant role on feature, an HTTP error ";
    private static final String ROLE_NAME_CANNOT_BE_NULL_NOR_EMPTY = "roleName cannot be null nor empty";
    private static final String FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY = "Feature identifier cannot be null nor empty";
    protected Client jersey1xClient = null;
    private String url = null;
    private String authorization = null;
    private WebResource storeWebRsc = null;
    private WebResource groupsWebRsc = null;

    public FeatureStoreHttp() {
    }

    public FeatureStoreHttp(String rootApiUrl) {
        this.url = rootApiUrl;
    }

    public FeatureStoreHttp(String rootApiUrl, String apiKey) {
        this(rootApiUrl);
        this.authorization = ClientHttpJersey1Utils.buildAuthorization4ApiKey(apiKey);
    }

    public FeatureStoreHttp(String rootApiUrl, String username, String password) {
        this(rootApiUrl);
        this.authorization = ClientHttpJersey1Utils.buildAuthorization4UserName(username, password);
    }

    public Client getJerseyClient() {
        if (this.jersey1xClient == null) {
            this.jersey1xClient = ClientHttpJersey1Utils.buildJersey1Client();
        }
        return this.jersey1xClient;
    }

    private WebResource getStore() {
        if (this.storeWebRsc == null) {
            Util.assertHasLength((String[])new String[]{this.url});
            this.storeWebRsc = this.getJerseyClient().resource(this.url).path("store").path("features");
            if (null != this.authorization) {
                this.storeWebRsc.header("Authorization", (Object)this.authorization);
            }
        }
        return this.storeWebRsc;
    }

    private WebResource getGroups() {
        if (this.groupsWebRsc == null) {
            Util.assertHasLength((String[])new String[]{this.url});
            this.groupsWebRsc = this.getJerseyClient().resource(this.url).path("store").path("groups");
            if (null != this.authorization) {
                this.groupsWebRsc.header("Authorization", (Object)this.authorization);
            }
        }
        return this.groupsWebRsc;
    }

    public Feature read(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException(FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(uid).get(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
        return FeatureJsonParser.parseFeature((String)((String)cRes.getEntity(String.class)));
    }

    public void enable(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException(FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(uid).path("enable").post(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
    }

    public void disable(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException(FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(uid).path("disable").post(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
    }

    public boolean exist(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException(FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(uid).get(ClientResponse.class);
        if (Response.Status.OK.getStatusCode() == cRes.getStatus()) {
            return true;
        }
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            return false;
        }
        throw new FeatureAccessException("Cannot check existence of feature, an HTTP error " + cRes.getStatus() + " occured : " + cRes.getEntityInputStream());
    }

    public void create(Feature fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Feature cannot be null nor empty");
        }
        if (this.exist(fp.getUid())) {
            throw new FeatureAlreadyExistException(fp.getUid());
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(fp.getUid()).type("application/json").put(ClientResponse.class, (Object)new FeatureApiBean(fp));
        if (Response.Status.CREATED.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot create feature, an HTTP error " + cRes.getStatus() + OCCURED);
        }
    }

    public Map<String, Feature> readAll() {
        ClientResponse cRes = (ClientResponse)this.getStore().get(ClientResponse.class);
        if (Response.Status.OK.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot read features, an HTTP error " + cRes.getStatus() + OCCURED);
        }
        String resEntity = (String)cRes.getEntity(String.class);
        Feature[] fArray = FeatureJsonParser.parseFeatureArray((String)resEntity);
        HashMap<String, Feature> features = new HashMap<String, Feature>();
        for (Feature feature : fArray) {
            features.put(feature.getUid(), feature);
        }
        return features;
    }

    public void delete(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException(FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(uid).delete(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot delete feature, an HTTP error " + cRes.getStatus() + OCCURED);
        }
    }

    public void update(Feature fp) {
        Util.assertNotNull((Object[])new Object[]{fp});
        if (!this.exist(fp.getUid())) {
            throw new FeatureNotFoundException(fp.getUid());
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(fp.getUid()).type("application/json").put(ClientResponse.class, (Object)new FeatureApiBean(fp));
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot update feature, an HTTP error " + cRes.getStatus() + OCCURED);
        }
    }

    public void grantRoleOnFeature(String uid, String roleName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException(FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (roleName == null || roleName.isEmpty()) {
            throw new IllegalArgumentException(ROLE_NAME_CANNOT_BE_NULL_NOR_EMPTY);
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(uid).path("grantrole").path(roleName).post(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException(CANNOT_GRANT_ROLE_ON_FEATURE_AN_HTTP_ERROR + cRes.getStatus() + OCCURED);
        }
    }

    public void removeRoleFromFeature(String uid, String roleName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException(FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (roleName == null || roleName.isEmpty()) {
            throw new IllegalArgumentException(ROLE_NAME_CANNOT_BE_NULL_NOR_EMPTY);
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(uid).path("removerole").path(roleName).post(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot remove role on feature, an HTTP error " + cRes.getStatus() + OCCURED);
        }
    }

    public void addToGroup(String uid, String groupName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException(FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException(GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY);
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(uid).path("addGroup").path(groupName).post(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot add feature to group, an HTTP error " + cRes.getStatus() + OCCURED);
        }
    }

    public void removeFromGroup(String uid, String groupName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException(FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException(GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY);
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(uid).path("removeGroup").path(groupName).post(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
        if (Response.Status.BAD_REQUEST.getStatusCode() == cRes.getStatus()) {
            throw new GroupNotFoundException(groupName);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot remove feature from group, an HTTP error " + cRes.getStatus() + OCCURED);
        }
    }

    public void enableGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException(GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY);
        }
        ClientResponse cRes = (ClientResponse)this.getGroups().path(groupName).path("enable").post(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new GroupNotFoundException(groupName);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException(CANNOT_GRANT_ROLE_ON_FEATURE_AN_HTTP_ERROR + cRes.getStatus() + OCCURED);
        }
    }

    public void disableGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException(GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY);
        }
        ClientResponse cRes = (ClientResponse)this.getGroups().path(groupName).path("disable").post(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new GroupNotFoundException(groupName);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException(CANNOT_GRANT_ROLE_ON_FEATURE_AN_HTTP_ERROR + cRes.getStatus() + OCCURED);
        }
    }

    public Map<String, Feature> readGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException(GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY);
        }
        ClientResponse cRes = (ClientResponse)this.getGroups().path(groupName).get(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new GroupNotFoundException(groupName);
        }
        if (Response.Status.OK.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException(CANNOT_GRANT_ROLE_ON_FEATURE_AN_HTTP_ERROR + cRes.getStatus() + OCCURED);
        }
        String resEntity = (String)cRes.getEntity(String.class);
        Feature[] fArray = FeatureJsonParser.parseFeatureArray((String)resEntity);
        HashMap<String, Feature> features = new HashMap<String, Feature>();
        for (Feature feature : fArray) {
            features.put(feature.getUid(), feature);
        }
        return features;
    }

    public boolean existGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException(GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY);
        }
        ClientResponse cRes = (ClientResponse)this.getGroups().path(groupName).get(ClientResponse.class);
        if (Response.Status.OK.getStatusCode() == cRes.getStatus()) {
            return true;
        }
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            return false;
        }
        throw new FeatureAccessException("Cannot check existence of group , an HTTP error " + cRes.getStatus() + OCCURED);
    }

    public Set<String> readAllGroups() {
        ClientResponse cRes = (ClientResponse)this.getGroups().get(ClientResponse.class);
        List groupApiBeans = (List)cRes.getEntity((GenericType)new GenericType<List<GroupDescApiBean>>(){});
        if (Response.Status.OK.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot read groups, an HTTP error " + cRes.getStatus() + OCCURED);
        }
        HashSet<String> groupNames = new HashSet<String>();
        for (GroupDescApiBean groupApiBean : groupApiBeans) {
            groupNames.add(groupApiBean.getGroupName());
        }
        return groupNames;
    }

    public void clear() {
        Util.assertHasLength((String[])new String[]{this.url});
        WebResource wr = this.getJerseyClient().resource(this.url).path("store").path("clear");
        if (null != this.authorization) {
            wr.header("Authorization", (Object)this.authorization);
        }
        ClientResponse cRes = (ClientResponse)wr.post(ClientResponse.class);
        if (Response.Status.OK.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot clear feature store - " + cRes.getStatus());
        }
    }

    public void createSchema() {
        Util.assertHasLength((String[])new String[]{this.url});
        WebResource wr = this.getJerseyClient().resource(this.url).path("store").path("createSchema");
        if (null != this.authorization) {
            wr.header("Authorization", (Object)this.authorization);
        }
        ClientResponse cRes = (ClientResponse)wr.post(ClientResponse.class);
        if (Response.Status.OK.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot create schema for feature store - " + cRes.getStatus());
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

