/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.jersey1.store;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.ff4j.exception.FeatureAccessException;
import org.ff4j.exception.PropertyAccessException;
import org.ff4j.exception.PropertyAlreadyExistException;
import org.ff4j.exception.PropertyNotFoundException;
import org.ff4j.property.Property;
import org.ff4j.property.store.AbstractPropertyStore;
import org.ff4j.utils.Util;
import org.ff4j.utils.json.PropertyJsonParser;
import org.ff4j.web.api.resources.domain.PropertyApiBean;
import org.ff4j.web.api.security.ClientHttpJersey1Utils;

public class PropertyStoreHttp
extends AbstractPropertyStore {
    public static final String OCCURED = " occured.";
    protected Client jersey1xClient = null;
    private String url = null;
    private String authorization = null;
    private WebResource storeWebRsc = null;

    public PropertyStoreHttp() {
    }

    public PropertyStoreHttp(String rootApiUrl) {
        this.url = rootApiUrl;
    }

    public PropertyStoreHttp(String rootApiUrl, String apiKey) {
        this(rootApiUrl);
        this.authorization = ClientHttpJersey1Utils.buildAuthorization4ApiKey(apiKey);
    }

    public PropertyStoreHttp(String rootApiUrl, String username, String password) {
        this(rootApiUrl);
        this.authorization = ClientHttpJersey1Utils.buildAuthorization4UserName(username, password);
    }

    public Client getJerseyClient() {
        if (this.jersey1xClient == null) {
            this.jersey1xClient = ClientHttpJersey1Utils.buildJersey1Client();
        }
        return this.jersey1xClient;
    }

    private WebResource getStore() {
        if (this.storeWebRsc == null) {
            Util.assertHasLength((String[])new String[]{this.url});
            this.storeWebRsc = this.getJerseyClient().resource(this.url).path("propertyStore").path("properties");
            if (null != this.authorization) {
                this.storeWebRsc.header("Authorization", (Object)this.authorization);
            }
        }
        return this.storeWebRsc;
    }

    public boolean existProperty(String name) {
        Util.assertHasLength((String[])new String[]{name});
        ClientResponse cRes = (ClientResponse)this.getStore().path(name).get(ClientResponse.class);
        if (Response.Status.OK.getStatusCode() == cRes.getStatus()) {
            return true;
        }
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            return false;
        }
        throw new PropertyAccessException("Cannot check existence of property, an HTTP error " + cRes.getStatus() + " occured : " + cRes.getEntityInputStream());
    }

    public void createSchema() {
        Util.assertHasLength((String[])new String[]{this.url});
        WebResource wr = this.getJerseyClient().resource(this.url).path("store").path("createSchema");
        if (null != this.authorization) {
            wr.header("Authorization", (Object)this.authorization);
        }
        ClientResponse cRes = (ClientResponse)wr.post(ClientResponse.class);
        if (Response.Status.OK.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot create schema for property store - " + cRes.getStatus());
        }
    }

    public <T> void createProperty(Property<T> value) {
        Util.assertNotNull((Object[])new Object[]{value});
        Util.assertHasLength((String[])new String[]{value.getName()});
        if (this.existProperty(value.getName())) {
            throw new PropertyAlreadyExistException("Property already exist");
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(value.getName()).type("application/json").put(ClientResponse.class, (Object)new PropertyApiBean(value));
        if (Response.Status.CREATED.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot create properties, an HTTP error " + cRes.getStatus() + OCCURED);
        }
    }

    public Property<?> readProperty(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Property name cannot be null nor empty");
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(name).get(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new PropertyNotFoundException(name);
        }
        return PropertyJsonParser.parseProperty((String)((String)cRes.getEntity(String.class)));
    }

    public void deleteProperty(String name) {
        Util.assertHasLength((String[])new String[]{name});
        ClientResponse cRes = (ClientResponse)this.getStore().path(name).delete(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new PropertyNotFoundException(name);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new PropertyAccessException("Cannot delete property, an HTTP error " + cRes.getStatus() + OCCURED);
        }
    }

    public Map<String, Property<?>> readAllProperties() {
        ClientResponse cRes = (ClientResponse)this.getStore().get(ClientResponse.class);
        if (Response.Status.OK.getStatusCode() != cRes.getStatus()) {
            throw new PropertyAccessException("Cannot read properties, an HTTP error " + cRes.getStatus() + OCCURED);
        }
        String resEntity = (String)cRes.getEntity(String.class);
        Property[] pArray = PropertyJsonParser.parsePropertyArray((String)resEntity);
        HashMap properties = new HashMap();
        for (Property pName : pArray) {
            properties.put(pName.getName(), pName);
        }
        return properties;
    }

    public Set<String> listPropertyNames() {
        return this.readAllProperties().keySet();
    }

    public void clear() {
        Util.assertHasLength((String[])new String[]{this.url});
        WebResource wr = this.getJerseyClient().resource(this.url).path("propertyStore").path("clear");
        if (null != this.authorization) {
            wr.header("Authorization", (Object)this.authorization);
        }
        ClientResponse cRes = (ClientResponse)wr.post(ClientResponse.class);
        if (Response.Status.OK.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot clear property store - " + cRes.getStatus());
        }
    }
}

