/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.impl;

import java.io.InputStream;
import java.util.List;
import org.flowable.app.api.AppRepositoryService;
import org.flowable.app.api.repository.AppDefinition;
import org.flowable.app.api.repository.AppDefinitionQuery;
import org.flowable.app.api.repository.AppDeployment;
import org.flowable.app.api.repository.AppDeploymentBuilder;
import org.flowable.app.api.repository.AppDeploymentQuery;
import org.flowable.app.api.repository.AppModel;
import org.flowable.app.engine.AppEngineConfiguration;
import org.flowable.app.engine.impl.cmd.DeleteDeploymentCmd;
import org.flowable.app.engine.impl.cmd.DeployCmd;
import org.flowable.app.engine.impl.cmd.GetAppModelCmd;
import org.flowable.app.engine.impl.cmd.GetAppModelJsonCmd;
import org.flowable.app.engine.impl.cmd.GetDeploymentAppDefinitionCmd;
import org.flowable.app.engine.impl.cmd.GetDeploymentResourceCmd;
import org.flowable.app.engine.impl.cmd.GetDeploymentResourceNamesCmd;
import org.flowable.app.engine.impl.cmd.SetAppDefinitionCategoryCmd;
import org.flowable.app.engine.impl.repository.AppDeploymentBuilderImpl;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.service.CommonEngineServiceImpl;

public class AppRepositoryServiceImpl
extends CommonEngineServiceImpl<AppEngineConfiguration>
implements AppRepositoryService {
    public AppRepositoryServiceImpl(AppEngineConfiguration engineConfiguration) {
        super((AbstractEngineConfiguration)engineConfiguration);
    }

    public AppDeploymentBuilder createDeployment() {
        return (AppDeploymentBuilder)this.commandExecutor.execute((Command)new Command<AppDeploymentBuilder>(){

            public AppDeploymentBuilder execute(CommandContext commandContext) {
                return new AppDeploymentBuilderImpl();
            }
        });
    }

    public List<String> getDeploymentResourceNames(String deploymentId) {
        return (List)this.commandExecutor.execute((Command)new GetDeploymentResourceNamesCmd(deploymentId));
    }

    public InputStream getResourceAsStream(String deploymentId, String resourceName) {
        return (InputStream)this.commandExecutor.execute((Command)new GetDeploymentResourceCmd(deploymentId, resourceName));
    }

    public AppDeployment deploy(AppDeploymentBuilderImpl deploymentBuilder) {
        return (AppDeployment)this.commandExecutor.execute((Command)new DeployCmd(deploymentBuilder));
    }

    public AppDefinition getAppDefinition(String appDefinitionId) {
        return (AppDefinition)this.commandExecutor.execute((Command)new GetDeploymentAppDefinitionCmd(appDefinitionId));
    }

    public AppModel getAppModel(String appDefinitionId) {
        return (AppModel)this.commandExecutor.execute((Command)new GetAppModelCmd(appDefinitionId));
    }

    public String convertAppModelToJson(String appDefinitionId) {
        return (String)this.commandExecutor.execute((Command)new GetAppModelJsonCmd(appDefinitionId));
    }

    public void deleteDeployment(String deploymentId, boolean cascade) {
        this.commandExecutor.execute((Command)new DeleteDeploymentCmd(deploymentId, cascade));
    }

    public AppDeploymentQuery createDeploymentQuery() {
        return ((AppEngineConfiguration)((Object)this.configuration)).getAppDeploymentEntityManager().createDeploymentQuery();
    }

    public AppDefinitionQuery createAppDefinitionQuery() {
        return ((AppEngineConfiguration)((Object)this.configuration)).getAppDefinitionEntityManager().createAppDefinitionQuery();
    }

    public void setAppDefinitionCategory(String appDefinitionId, String category) {
        this.commandExecutor.execute((Command)new SetAppDefinitionCategoryCmd(appDefinitionId, category));
    }
}

