/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.impl.cmd;

import org.flowable.app.api.repository.AppDefinition;
import org.flowable.app.engine.impl.cmd.NeedsAppDefinitionCmd;
import org.flowable.app.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class AddIdentityLinkCmd
extends NeedsAppDefinitionCmd<Void> {
    private static final long serialVersionUID = 1L;
    public static int IDENTITY_USER = 1;
    public static int IDENTITY_GROUP = 2;
    protected String identityId;
    protected int identityIdType;
    protected String identityType;

    public AddIdentityLinkCmd(String appDefinitionId, String identityId, int identityIdType, String identityType) {
        super(appDefinitionId);
        this.validateParams(appDefinitionId, identityId, identityIdType, identityType);
        this.appDefinitionId = appDefinitionId;
        this.identityId = identityId;
        this.identityIdType = identityIdType;
        this.identityType = identityType;
    }

    protected void validateParams(String appDefinitionId, String identityId, int identityIdType, String identityType) {
        if (appDefinitionId == null) {
            throw new FlowableIllegalArgumentException("appDefinitionId is null");
        }
        if (identityType == null) {
            throw new FlowableIllegalArgumentException("type is required when adding a new task identity link");
        }
        if (identityId == null) {
            throw new FlowableIllegalArgumentException("identityId is null");
        }
        if (identityIdType != IDENTITY_USER && identityIdType != IDENTITY_GROUP) {
            throw new FlowableIllegalArgumentException("identityIdType allowed values are 1 and 2");
        }
    }

    @Override
    protected Void execute(CommandContext commandContext, AppDefinition appDefinition) {
        if (IDENTITY_USER == this.identityIdType) {
            CommandContextUtil.getIdentityLinkService().createScopeIdentityLink(appDefinition.getId(), null, "app", this.identityId, null, this.identityType);
        } else if (IDENTITY_GROUP == this.identityIdType) {
            CommandContextUtil.getIdentityLinkService().createScopeIdentityLink(appDefinition.getId(), null, "app", null, this.identityId, this.identityType);
        }
        return null;
    }
}

