/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.impl.cmd;

import org.flowable.app.api.repository.AppDefinition;
import org.flowable.app.engine.AppEngineConfiguration;
import org.flowable.app.engine.impl.deployer.AppDeploymentManager;
import org.flowable.app.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class GetAppModelJsonCmd
implements Command<String> {
    protected String appDefinitionId;

    public GetAppModelJsonCmd(String appDefinitionId) {
        this.appDefinitionId = appDefinitionId;
    }

    public String execute(CommandContext commandContext) {
        if (this.appDefinitionId == null) {
            throw new FlowableIllegalArgumentException("appDefinitionId is null");
        }
        AppEngineConfiguration appEngineConfiguration = CommandContextUtil.getAppEngineConfiguration(commandContext);
        AppDeploymentManager deploymentManager = appEngineConfiguration.getDeploymentManager();
        AppDefinition appDefinition = deploymentManager.findDeployedAppDefinitionById(this.appDefinitionId);
        if (appDefinition != null) {
            return appEngineConfiguration.getAppResourceConverter().convertAppModelToJson(deploymentManager.resolveAppDefinition(appDefinition).getAppModel());
        }
        return null;
    }
}

