/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.common.impl.transaction;

import java.util.Stack;
import org.flowable.engine.common.impl.cfg.BaseTransactionContext;

public class TransactionContextHolder {
    protected static ThreadLocal<Stack<BaseTransactionContext>> transactionContextThreadLocal = new ThreadLocal();

    public static BaseTransactionContext getTransactionContext() {
        Stack stack = TransactionContextHolder.getStack(transactionContextThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (BaseTransactionContext)stack.peek();
    }

    public static void setTransactionContext(BaseTransactionContext transactionContext) {
        TransactionContextHolder.getStack(transactionContextThreadLocal).push(transactionContext);
    }

    public static void removeTransactionContext() {
        TransactionContextHolder.getStack(transactionContextThreadLocal).pop();
    }

    public static boolean isTransactionContextActive() {
        return !TransactionContextHolder.getStack(transactionContextThreadLocal).isEmpty();
    }

    protected static <T> Stack<T> getStack(ThreadLocal<Stack<T>> threadLocal) {
        Stack<Object> stack = threadLocal.get();
        if (stack == null) {
            stack = new Stack();
            threadLocal.set(stack);
        }
        return stack;
    }
}

