/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.common.impl.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.flowable.engine.common.impl.context.Context;
import org.flowable.engine.common.impl.db.CachedEntityMatcher;
import org.flowable.engine.common.impl.db.DbSqlSession;
import org.flowable.engine.common.impl.db.SingleCachedEntityMatcher;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.persistence.cache.CachedEntity;
import org.flowable.engine.common.impl.persistence.cache.EntityCache;
import org.flowable.engine.common.impl.persistence.entity.Entity;
import org.flowable.engine.common.impl.persistence.entity.data.DataManager;

public abstract class AbstractDataManager<EntityImpl extends Entity>
implements DataManager<EntityImpl> {
    public abstract Class<? extends EntityImpl> getManagedEntityClass();

    public List<Class<? extends EntityImpl>> getManagedEntitySubClasses() {
        return null;
    }

    protected CommandContext getCommandContext() {
        return Context.getCommandContext();
    }

    protected <T> T getSession(Class<T> sessionClass) {
        return this.getCommandContext().getSession(sessionClass);
    }

    protected DbSqlSession getDbSqlSession() {
        return this.getSession(DbSqlSession.class);
    }

    protected EntityCache getEntityCache() {
        return this.getSession(EntityCache.class);
    }

    @Override
    public EntityImpl findById(String entityId) {
        if (entityId == null) {
            return null;
        }
        Entity cachedEntity = (Entity)this.getEntityCache().findInCache(this.getManagedEntityClass(), entityId);
        if (cachedEntity != null) {
            return (EntityImpl)cachedEntity;
        }
        return this.getDbSqlSession().selectById(this.getManagedEntityClass(), entityId, false);
    }

    @Override
    public void insert(EntityImpl entity) {
        this.getDbSqlSession().insert((Entity)entity);
    }

    @Override
    public EntityImpl update(EntityImpl entity) {
        this.getDbSqlSession().update((Entity)entity);
        return entity;
    }

    @Override
    public void delete(String id) {
        EntityImpl entity = this.findById(id);
        this.delete(entity);
    }

    @Override
    public void delete(EntityImpl entity) {
        this.getDbSqlSession().delete((Entity)entity);
    }

    protected EntityImpl findByQuery(String selectQuery, Object parameter) {
        return (EntityImpl)((Entity)this.getDbSqlSession().selectOne(selectQuery, parameter));
    }

    protected List<EntityImpl> getList(String dbQueryName, Object parameter) {
        List result = this.getDbSqlSession().selectList(dbQueryName, parameter);
        return new ArrayList(result);
    }

    protected EntityImpl getEntity(String selectQuery, Object parameter, SingleCachedEntityMatcher<EntityImpl> cachedEntityMatcher, boolean checkDatabase) {
        for (Entity cachedEntity : this.getEntityCache().findInCache(this.getManagedEntityClass())) {
            if (!cachedEntityMatcher.isRetained(cachedEntity, parameter)) continue;
            return (EntityImpl)cachedEntity;
        }
        if (checkDatabase) {
            return (EntityImpl)((Entity)this.getDbSqlSession().selectOne(selectQuery, parameter));
        }
        return null;
    }

    protected List<EntityImpl> getList(String dbQueryName, Object parameter, CachedEntityMatcher<EntityImpl> cachedEntityMatcher) {
        return this.getList(dbQueryName, parameter, cachedEntityMatcher, true);
    }

    protected List<EntityImpl> getList(String dbQueryName, Object parameter, CachedEntityMatcher<EntityImpl> cachedEntityMatcher, boolean checkCache) {
        Collection<CachedEntity> cachedObjects;
        Collection<Object> result = this.getDbSqlSession().selectList(dbQueryName, parameter);
        if (checkCache && ((cachedObjects = this.getEntityCache().findInCacheAsCachedObjects(this.getManagedEntityClass())) != null && cachedObjects.size() > 0 || this.getManagedEntitySubClasses() != null)) {
            HashMap<String, Entity> entityMap = new HashMap<String, Entity>(result.size());
            for (Entity entity : result) {
                entityMap.put(entity.getId(), entity);
            }
            if (cachedObjects != null && cachedEntityMatcher != null) {
                for (CachedEntity cachedEntity : cachedObjects) {
                    Entity cachedEntity2 = cachedEntity.getEntity();
                    if (!cachedEntityMatcher.isRetained(result, cachedObjects, cachedEntity2, parameter)) continue;
                    entityMap.put(cachedEntity2.getId(), cachedEntity2);
                }
            }
            if (this.getManagedEntitySubClasses() != null && cachedEntityMatcher != null) {
                for (Class clazz : this.getManagedEntitySubClasses()) {
                    Collection<CachedEntity> subclassCachedObjects = this.getEntityCache().findInCacheAsCachedObjects(clazz);
                    if (subclassCachedObjects == null) continue;
                    for (CachedEntity subclassCachedObject : subclassCachedObjects) {
                        Entity cachedSubclassEntity = subclassCachedObject.getEntity();
                        if (!cachedEntityMatcher.isRetained(result, cachedObjects, cachedSubclassEntity, parameter)) continue;
                        entityMap.put(cachedSubclassEntity.getId(), cachedSubclassEntity);
                    }
                }
            }
            result = entityMap.values();
        }
        if (result.size() > 0) {
            Iterator resultIterator = result.iterator();
            while (resultIterator.hasNext()) {
                if (!this.getDbSqlSession().isEntityToBeDeleted((Entity)resultIterator.next())) continue;
                resultIterator.remove();
            }
        }
        return new ArrayList(result);
    }

    protected List<EntityImpl> getListFromCache(CachedEntityMatcher<EntityImpl> entityMatcher, Object parameter) {
        Collection<CachedEntity> cachedObjects = this.getEntityCache().findInCacheAsCachedObjects(this.getManagedEntityClass());
        DbSqlSession dbSqlSession = this.getDbSqlSession();
        ArrayList<Entity> result = new ArrayList<Entity>(cachedObjects.size());
        if (cachedObjects != null && entityMatcher != null) {
            for (CachedEntity cachedEntity : cachedObjects) {
                Entity cachedEntity2 = cachedEntity.getEntity();
                if (!entityMatcher.isRetained(null, cachedObjects, cachedEntity2, parameter) || dbSqlSession.isEntityToBeDeleted(cachedEntity2)) continue;
                result.add(cachedEntity2);
            }
        }
        if (this.getManagedEntitySubClasses() != null && entityMatcher != null) {
            for (Class clazz : this.getManagedEntitySubClasses()) {
                Collection<CachedEntity> subclassCachedObjects = this.getEntityCache().findInCacheAsCachedObjects(clazz);
                if (subclassCachedObjects == null) continue;
                for (CachedEntity subclassCachedObject : subclassCachedObjects) {
                    Entity cachedSubclassEntity = subclassCachedObject.getEntity();
                    if (!entityMatcher.isRetained(null, cachedObjects, cachedSubclassEntity, parameter) || dbSqlSession.isEntityToBeDeleted(cachedSubclassEntity)) continue;
                    result.add(cachedSubclassEntity);
                }
            }
        }
        return result;
    }
}

