/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.common.impl.de.odysseus.el.tree.impl.ast;

import org.flowable.engine.common.impl.de.odysseus.el.misc.BooleanOperations;
import org.flowable.engine.common.impl.de.odysseus.el.misc.NumberOperations;
import org.flowable.engine.common.impl.de.odysseus.el.misc.TypeConverter;
import org.flowable.engine.common.impl.de.odysseus.el.tree.Bindings;
import org.flowable.engine.common.impl.de.odysseus.el.tree.impl.ast.AstNode;
import org.flowable.engine.common.impl.de.odysseus.el.tree.impl.ast.AstRightValue;
import org.flowable.engine.common.impl.javax.el.ELContext;

public class AstBinary
extends AstRightValue {
    public static final Operator ADD = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2) {
            return NumberOperations.add(converter, o1, o2);
        }

        public String toString() {
            return "+";
        }
    };
    public static final Operator AND = new Operator(){

        @Override
        public Object eval(Bindings bindings, ELContext context, AstNode left, AstNode right) {
            Boolean l = bindings.convert(left.eval(bindings, context), Boolean.class);
            return Boolean.TRUE.equals(l) ? bindings.convert(right.eval(bindings, context), Boolean.class) : Boolean.FALSE;
        }

        public String toString() {
            return "&&";
        }
    };
    public static final Operator DIV = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2) {
            return NumberOperations.div(converter, o1, o2);
        }

        public String toString() {
            return "/";
        }
    };
    public static final Operator EQ = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2) {
            return BooleanOperations.eq(converter, o1, o2);
        }

        public String toString() {
            return "==";
        }
    };
    public static final Operator GE = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2) {
            return BooleanOperations.ge(converter, o1, o2);
        }

        public String toString() {
            return ">=";
        }
    };
    public static final Operator GT = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2) {
            return BooleanOperations.gt(converter, o1, o2);
        }

        public String toString() {
            return ">";
        }
    };
    public static final Operator LE = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2) {
            return BooleanOperations.le(converter, o1, o2);
        }

        public String toString() {
            return "<=";
        }
    };
    public static final Operator LT = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2) {
            return BooleanOperations.lt(converter, o1, o2);
        }

        public String toString() {
            return "<";
        }
    };
    public static final Operator MOD = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2) {
            return NumberOperations.mod(converter, o1, o2);
        }

        public String toString() {
            return "%";
        }
    };
    public static final Operator MUL = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2) {
            return NumberOperations.mul(converter, o1, o2);
        }

        public String toString() {
            return "*";
        }
    };
    public static final Operator NE = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2) {
            return BooleanOperations.ne(converter, o1, o2);
        }

        public String toString() {
            return "!=";
        }
    };
    public static final Operator OR = new Operator(){

        @Override
        public Object eval(Bindings bindings, ELContext context, AstNode left, AstNode right) {
            Boolean l = bindings.convert(left.eval(bindings, context), Boolean.class);
            return Boolean.TRUE.equals(l) ? Boolean.TRUE : bindings.convert(right.eval(bindings, context), Boolean.class);
        }

        public String toString() {
            return "||";
        }
    };
    public static final Operator SUB = new SimpleOperator(){

        @Override
        public Object apply(TypeConverter converter, Object o1, Object o2) {
            return NumberOperations.sub(converter, o1, o2);
        }

        public String toString() {
            return "-";
        }
    };
    private final Operator operator;
    private final AstNode left;
    private final AstNode right;

    public AstBinary(AstNode left, AstNode right, Operator operator) {
        this.left = left;
        this.right = right;
        this.operator = operator;
    }

    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public Object eval(Bindings bindings, ELContext context) {
        return this.operator.eval(bindings, context, this.left, this.right);
    }

    public String toString() {
        return "'" + this.operator.toString() + "'";
    }

    @Override
    public void appendStructure(StringBuilder b, Bindings bindings) {
        this.left.appendStructure(b, bindings);
        b.append(' ');
        b.append(this.operator);
        b.append(' ');
        this.right.appendStructure(b, bindings);
    }

    @Override
    public int getCardinality() {
        return 2;
    }

    @Override
    public AstNode getChild(int i) {
        return i == 0 ? this.left : (i == 1 ? this.right : null);
    }

    public static abstract class SimpleOperator
    implements Operator {
        @Override
        public Object eval(Bindings bindings, ELContext context, AstNode left, AstNode right) {
            return this.apply(bindings, left.eval(bindings, context), right.eval(bindings, context));
        }

        protected abstract Object apply(TypeConverter var1, Object var2, Object var3);
    }

    public static interface Operator {
        public Object eval(Bindings var1, ELContext var2, AstNode var3, AstNode var4);
    }
}

