/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.common.impl.el;

import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.delegate.Expression;
import org.flowable.engine.common.api.variable.VariableContainer;
import org.flowable.engine.common.impl.el.ExpressionManager;
import org.flowable.engine.common.impl.javax.el.ELContext;
import org.flowable.engine.common.impl.javax.el.MethodNotFoundException;
import org.flowable.engine.common.impl.javax.el.PropertyNotFoundException;
import org.flowable.engine.common.impl.javax.el.ValueExpression;

public class JuelExpression
implements Expression {
    private static final long serialVersionUID = 1L;
    protected String expressionText;
    protected ValueExpression valueExpression;
    protected ExpressionManager expressionManager;

    public JuelExpression(ExpressionManager expressionManager, ValueExpression valueExpression, String expressionText) {
        this.valueExpression = valueExpression;
        this.expressionText = expressionText;
        this.expressionManager = expressionManager;
    }

    public Object getValue(VariableContainer variableContainer) {
        ELContext elContext = this.expressionManager.getElContext(variableContainer);
        try {
            return this.resolveGetValueExpression(elContext);
        }
        catch (PropertyNotFoundException pnfe) {
            throw new FlowableException("Unknown property used in expression: " + this.expressionText, (Throwable)pnfe);
        }
        catch (MethodNotFoundException mnfe) {
            throw new FlowableException("Unknown method used in expression: " + this.expressionText, (Throwable)mnfe);
        }
        catch (Exception e) {
            throw new FlowableException("Error while evaluating expression: " + this.expressionText, (Throwable)e);
        }
    }

    protected Object resolveGetValueExpression(ELContext elContext) {
        return this.valueExpression.getValue(elContext);
    }

    public void setValue(Object value, VariableContainer variableContainer) {
        ELContext elContext = this.expressionManager.getElContext(variableContainer);
        try {
            this.resolveSetValueExpression(value, elContext);
        }
        catch (Exception e) {
            throw new FlowableException("Error while evaluating expression: " + this.expressionText, (Throwable)e);
        }
    }

    protected void resolveSetValueExpression(Object value, ELContext elContext) {
        this.valueExpression.setValue(elContext, value);
    }

    public String toString() {
        if (this.valueExpression != null) {
            return this.valueExpression.getExpressionString();
        }
        return super.toString();
    }

    public String getExpressionText() {
        return this.expressionText;
    }
}

