/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.util.GregorianCalendar;
import java.util.List;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.asyncexecutor.AcquiredJobEntities;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.JobEntity;

public class AcquireTimerJobsCmd
implements Command<AcquiredJobEntities> {
    private final String lockOwner;
    private final int lockTimeInMillis;
    private final int maxJobsPerAcquisition;

    public AcquireTimerJobsCmd(String lockOwner, int lockTimeInMillis, int maxJobsPerAcquisition) {
        this.lockOwner = lockOwner;
        this.lockTimeInMillis = lockTimeInMillis;
        this.maxJobsPerAcquisition = maxJobsPerAcquisition;
    }

    @Override
    public AcquiredJobEntities execute(CommandContext commandContext) {
        AcquiredJobEntities acquiredJobs = new AcquiredJobEntities();
        List<JobEntity> jobs = commandContext.getJobEntityManager().findNextTimerJobsToExecute(new Page(0, this.maxJobsPerAcquisition));
        for (JobEntity job : jobs) {
            if (job == null || acquiredJobs.contains(job.getId())) continue;
            this.lockJob(commandContext, job, this.lockOwner, this.lockTimeInMillis);
            acquiredJobs.addJob(job);
        }
        return acquiredJobs;
    }

    protected void lockJob(CommandContext commandContext, JobEntity job, String lockOwner, int lockTimeInMillis) {
        job.setLockOwner(lockOwner);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
        gregorianCalendar.add(14, lockTimeInMillis);
        job.setLockExpirationTime(gregorianCalendar.getTime());
    }
}

