/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.runtime.ProcessInstanceBuilderImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;

public class StartProcessInstanceByMessageCmd
implements Command<ProcessInstance> {
    protected final String messageName;
    protected final String businessKey;
    protected final Map<String, Object> processVariables;
    protected Map<String, Object> transientVariables;
    protected final String tenantId;

    public StartProcessInstanceByMessageCmd(String messageName, String businessKey, Map<String, Object> processVariables, String tenantId) {
        this.messageName = messageName;
        this.businessKey = businessKey;
        this.processVariables = processVariables;
        this.tenantId = tenantId;
    }

    public StartProcessInstanceByMessageCmd(ProcessInstanceBuilderImpl processInstanceBuilder) {
        this.messageName = processInstanceBuilder.getMessageName();
        this.businessKey = processInstanceBuilder.getBusinessKey();
        this.processVariables = processInstanceBuilder.getVariables();
        this.transientVariables = processInstanceBuilder.getTransientVariables();
        this.tenantId = processInstanceBuilder.getTenantId();
    }

    @Override
    public ProcessInstance execute(CommandContext commandContext) {
        if (this.messageName == null) {
            throw new ActivitiIllegalArgumentException("Cannot start process instance by message: message name is null");
        }
        MessageEventSubscriptionEntity messageEventSubscription = commandContext.getEventSubscriptionEntityManager().findMessageStartEventSubscriptionByName(this.messageName, this.tenantId);
        if (messageEventSubscription == null) {
            throw new ActivitiObjectNotFoundException("Cannot start process instance by message: no subscription to message with name '" + this.messageName + "' found.", MessageEventSubscriptionEntity.class);
        }
        String processDefinitionId = messageEventSubscription.getConfiguration();
        if (processDefinitionId == null) {
            throw new ActivitiException("Cannot start process instance by message: subscription to message with name '" + this.messageName + "' is not a message start event.");
        }
        DeploymentManager deploymentManager = commandContext.getProcessEngineConfiguration().getDeploymentManager();
        ProcessDefinitionEntity processDefinition = deploymentManager.findDeployedProcessDefinitionById(processDefinitionId);
        if (processDefinition == null) {
            throw new ActivitiObjectNotFoundException("No process definition found for id '" + processDefinitionId + "'", ProcessDefinition.class);
        }
        if (deploymentManager.isProcessDefinitionSuspended(processDefinition.getId())) {
            throw new ActivitiException("Cannot start process instance. Process definition " + processDefinition.getName() + " (id = " + processDefinition.getId() + ") is suspended");
        }
        ActivityImpl startActivity = processDefinition.findActivity(messageEventSubscription.getActivityId());
        ExecutionEntity processInstance = processDefinition.createProcessInstance(this.businessKey, startActivity);
        if (this.processVariables != null) {
            processInstance.setVariables(this.processVariables);
        }
        if (this.transientVariables != null) {
            processInstance.setTransientVariables(this.transientVariables);
        }
        processInstance.start();
        return processInstance;
    }
}

