/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.agenda;

import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.agenda.AbstractOperation;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.flowable.engine.impl.delegate.TriggerableActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;

public class TriggerExecutionOperation
extends AbstractOperation {
    public TriggerExecutionOperation(CommandContext commandContext, ExecutionEntity execution) {
        super(commandContext, execution);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        ActivityBehavior activityBehavior;
        FlowElement currentFlowElement = this.getCurrentFlowElement(this.execution);
        if (currentFlowElement instanceof FlowNode) {
            activityBehavior = (ActivityBehavior)((FlowNode)currentFlowElement).getBehavior();
            if (!(activityBehavior instanceof TriggerableActivityBehavior)) throw new FlowableException("Cannot trigger execution with id " + this.execution.getId() + " : the activityBehavior " + activityBehavior.getClass() + " does not implement the " + TriggerableActivityBehavior.class.getName() + " interface");
            if (currentFlowElement instanceof BoundaryEvent || currentFlowElement instanceof ServiceTask) {
                CommandContextUtil.getHistoryManager(this.commandContext).recordActivityStart(this.execution);
            }
        } else {
            if (currentFlowElement != null) throw new FlowableException("Programmatic error: cannot trigger execution, invalid flowelement type found: " + currentFlowElement.getClass().getName() + ".");
            throw new FlowableException("Cannot trigger execution with id " + this.execution.getId() + " : no current flow element found. Check the execution id that is being passed (it should not be a process instance execution, but a child execution currently referencing a flow element).");
        }
        ((TriggerableActivityBehavior)activityBehavior).trigger(this.execution, null, null);
    }
}

