/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.InputStream;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.util.IoUtil;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.identity.Authentication;
import org.flowable.engine.impl.persistence.entity.AttachmentEntity;
import org.flowable.engine.impl.persistence.entity.ByteArrayEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.TaskEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.engine.task.Attachment;
import org.flowable.engine.task.Task;

public class CreateAttachmentCmd
implements Command<Attachment> {
    protected String attachmentType;
    protected String taskId;
    protected String processInstanceId;
    protected String attachmentName;
    protected String attachmentDescription;
    protected InputStream content;
    protected String url;

    public CreateAttachmentCmd(String attachmentType, String taskId, String processInstanceId, String attachmentName, String attachmentDescription, InputStream content, String url) {
        this.attachmentType = attachmentType;
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
        this.attachmentName = attachmentName;
        this.attachmentDescription = attachmentDescription;
        this.content = content;
        this.url = url;
    }

    public Attachment execute(CommandContext commandContext) {
        ExecutionEntity execution;
        TaskEntity task;
        if (this.taskId != null && (task = this.verifyTaskParameters(commandContext)).getProcessDefinitionId() != null && Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, task.getProcessDefinitionId())) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            return compatibilityHandler.createAttachment(this.attachmentType, this.taskId, this.processInstanceId, this.attachmentName, this.attachmentDescription, this.content, this.url);
        }
        if (this.processInstanceId != null && Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, (execution = this.verifyExecutionParameters(commandContext)).getProcessDefinitionId())) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            return compatibilityHandler.createAttachment(this.attachmentType, this.taskId, this.processInstanceId, this.attachmentName, this.attachmentDescription, this.content, this.url);
        }
        AttachmentEntity attachment = (AttachmentEntity)CommandContextUtil.getAttachmentEntityManager().create();
        attachment.setName(this.attachmentName);
        attachment.setProcessInstanceId(this.processInstanceId);
        attachment.setTaskId(this.taskId);
        attachment.setDescription(this.attachmentDescription);
        attachment.setType(this.attachmentType);
        attachment.setUrl(this.url);
        attachment.setUserId(Authentication.getAuthenticatedUserId());
        attachment.setTime(CommandContextUtil.getProcessEngineConfiguration(commandContext).getClock().getCurrentTime());
        CommandContextUtil.getAttachmentEntityManager().insert(attachment, false);
        if (this.content != null) {
            byte[] bytes = IoUtil.readInputStream((InputStream)this.content, (String)this.attachmentName);
            ByteArrayEntity byteArray = (ByteArrayEntity)CommandContextUtil.getByteArrayEntityManager().create();
            byteArray.setBytes(bytes);
            CommandContextUtil.getByteArrayEntityManager().insert(byteArray);
            attachment.setContentId(byteArray.getId());
            attachment.setContent(byteArray);
        }
        CommandContextUtil.getHistoryManager(commandContext).createAttachmentComment(this.taskId, this.processInstanceId, this.attachmentName, true);
        if (CommandContextUtil.getProcessEngineConfiguration(commandContext).getEventDispatcher().isEnabled()) {
            ExecutionEntity process;
            String processDefinitionId = null;
            if (attachment.getProcessInstanceId() != null && (process = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(this.processInstanceId)) != null) {
                processDefinitionId = process.getProcessDefinitionId();
            }
            CommandContextUtil.getProcessEngineConfiguration(commandContext).getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_CREATED, attachment, this.processInstanceId, this.processInstanceId, processDefinitionId));
            CommandContextUtil.getProcessEngineConfiguration(commandContext).getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_INITIALIZED, attachment, this.processInstanceId, this.processInstanceId, processDefinitionId));
        }
        return attachment;
    }

    protected TaskEntity verifyTaskParameters(CommandContext commandContext) {
        TaskEntity task = (TaskEntity)CommandContextUtil.getTaskEntityManager(commandContext).findById(this.taskId);
        if (task == null) {
            throw new FlowableObjectNotFoundException("Cannot find task with id " + this.taskId, Task.class);
        }
        if (task.isSuspended()) {
            throw new FlowableException("It is not allowed to add an attachment to a suspended task");
        }
        return task;
    }

    protected ExecutionEntity verifyExecutionParameters(CommandContext commandContext) {
        ExecutionEntity execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(this.processInstanceId);
        if (execution == null) {
            throw new FlowableObjectNotFoundException("Process instance " + this.processInstanceId + " doesn't exist", ProcessInstance.class);
        }
        if (execution.isSuspended()) {
            throw new FlowableException("It is not allowed to add an attachment to a suspended process instance");
        }
        return execution;
    }
}

