/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.history.async.json.transformer.AbstractHistoryJsonTransformer;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricTaskInstanceEntityManager;
import org.flowable.engine.impl.persistence.entity.HistoryJobEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskEndedHistoryJsonTransformer
extends AbstractHistoryJsonTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskEndedHistoryJsonTransformer.class);

    @Override
    public String getType() {
        return "task-ended";
    }

    @Override
    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        return true;
    }

    @Override
    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        String taskId = this.getStringFromJson(historicalData, "id");
        HistoricTaskInstanceEntityManager historicTaskInstanceEntityManager = CommandContextUtil.getHistoricTaskInstanceEntityManager(commandContext);
        HistoricTaskInstanceEntity historicTaskInstance = (HistoricTaskInstanceEntity)historicTaskInstanceEntityManager.findById(taskId);
        if (historicTaskInstance != null) {
            Date lastUpdateTime = this.getDateFromJson(historicalData, "__timeStamp");
            if (historicTaskInstance.getLastUpdateTime() == null || !historicTaskInstance.getLastUpdateTime().after(lastUpdateTime)) {
                historicTaskInstance.setLastUpdateTime(lastUpdateTime);
                historicTaskInstance.setName(this.getStringFromJson(historicalData, "name"));
                historicTaskInstance.setParentTaskId(this.getStringFromJson(historicalData, "parentTaskId"));
                historicTaskInstance.setDescription(this.getStringFromJson(historicalData, "description"));
                historicTaskInstance.setOwner(this.getStringFromJson(historicalData, "owner"));
                historicTaskInstance.setAssignee(this.getStringFromJson(historicalData, "assignee"));
                historicTaskInstance.setStartTime(this.getDateFromJson(historicalData, "startTime"));
                historicTaskInstance.setTaskDefinitionKey(this.getStringFromJson(historicalData, "taskDefinitionKey"));
                historicTaskInstance.setPriority(this.getIntegerFromJson(historicalData, "priority"));
                historicTaskInstance.setDueDate(this.getDateFromJson(historicalData, "dueDate"));
                historicTaskInstance.setCategory(this.getStringFromJson(historicalData, "category"));
                historicTaskInstance.setFormKey(this.getStringFromJson(historicalData, "formKey"));
                historicTaskInstance.setClaimTime(this.getDateFromJson(historicalData, "claimTime"));
                historicTaskInstance.setTenantId(this.getStringFromJson(historicalData, "tenantId"));
            }
            Date endTime = this.getDateFromJson(historicalData, "endTime");
            historicTaskInstance.setEndTime(endTime);
            historicTaskInstance.setDeleteReason(this.getStringFromJson(historicalData, "deleteReason"));
            Date startTime = historicTaskInstance.getStartTime();
            if (startTime != null && endTime != null) {
                historicTaskInstance.setDurationInMillis(endTime.getTime() - startTime.getTime());
            }
        } else {
            HistoricActivityInstanceEntity historicActivityInstanceEntity;
            String activityId;
            String executionId = this.getStringFromJson(historicalData, "executionId");
            historicTaskInstance = (HistoricTaskInstanceEntity)historicTaskInstanceEntityManager.create();
            historicTaskInstance.setId(taskId);
            historicTaskInstance.setProcessDefinitionId(this.getStringFromJson(historicalData, "processDefinitionId"));
            historicTaskInstance.setProcessInstanceId(this.getStringFromJson(historicalData, "processInstanceId"));
            historicTaskInstance.setExecutionId(executionId);
            historicTaskInstance.setName(this.getStringFromJson(historicalData, "name"));
            historicTaskInstance.setParentTaskId(this.getStringFromJson(historicalData, "parentTaskId"));
            historicTaskInstance.setDescription(this.getStringFromJson(historicalData, "description"));
            historicTaskInstance.setOwner(this.getStringFromJson(historicalData, "owner"));
            historicTaskInstance.setAssignee(this.getStringFromJson(historicalData, "assignee"));
            historicTaskInstance.setStartTime(this.getDateFromJson(historicalData, "startTime"));
            historicTaskInstance.setTaskDefinitionKey(this.getStringFromJson(historicalData, "taskDefinitionKey"));
            historicTaskInstance.setPriority(this.getIntegerFromJson(historicalData, "priority"));
            historicTaskInstance.setDueDate(this.getDateFromJson(historicalData, "dueDate"));
            historicTaskInstance.setCategory(this.getStringFromJson(historicalData, "category"));
            historicTaskInstance.setFormKey(this.getStringFromJson(historicalData, "formKey"));
            historicTaskInstance.setClaimTime(this.getDateFromJson(historicalData, "claimTime"));
            historicTaskInstance.setTenantId(this.getStringFromJson(historicalData, "tenantId"));
            historicTaskInstance.setLastUpdateTime(this.getDateFromJson(historicalData, "__timeStamp"));
            Date endTime = this.getDateFromJson(historicalData, "endTime");
            historicTaskInstance.setEndTime(endTime);
            historicTaskInstance.setDeleteReason(this.getStringFromJson(historicalData, "deleteReason"));
            Date startTime = historicTaskInstance.getStartTime();
            if (startTime != null && endTime != null) {
                historicTaskInstance.setDurationInMillis(endTime.getTime() - startTime.getTime());
            }
            historicTaskInstanceEntityManager.insert(historicTaskInstance);
            if (StringUtils.isNotEmpty((CharSequence)executionId) && StringUtils.isNotEmpty((CharSequence)(activityId = this.getStringFromJson(historicalData, "activityId"))) && (historicActivityInstanceEntity = this.findHistoricActivityInstance(commandContext, executionId, activityId)) != null) {
                historicActivityInstanceEntity.setTaskId(taskId);
            }
        }
    }
}

