/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.variable;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.context.Context;
import org.flowable.engine.common.impl.interceptor.CommandContextCloseListener;
import org.flowable.engine.common.impl.util.IoUtil;
import org.flowable.engine.common.impl.util.ReflectUtil;
import org.flowable.engine.impl.persistence.entity.VariableInstanceEntity;
import org.flowable.engine.impl.variable.ByteArrayType;
import org.flowable.engine.impl.variable.DeserializedObject;
import org.flowable.engine.impl.variable.ValueFields;
import org.flowable.engine.impl.variable.VerifyDeserializedObjectCommandContextCloseListener;

public class SerializableType
extends ByteArrayType {
    public static final String TYPE_NAME = "serializable";
    protected boolean trackDeserializedObjects;

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    public SerializableType() {
    }

    public SerializableType(boolean trackDeserializedObjects) {
        this.trackDeserializedObjects = trackDeserializedObjects;
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        Object cachedObject = valueFields.getCachedValue();
        if (cachedObject != null) {
            return cachedObject;
        }
        byte[] bytes = (byte[])super.getValue(valueFields);
        if (bytes != null) {
            Object deserializedObject = this.deserialize(bytes, valueFields);
            valueFields.setCachedValue(deserializedObject);
            if (this.trackDeserializedObjects && valueFields instanceof VariableInstanceEntity) {
                Context.getCommandContext().addCloseListener((CommandContextCloseListener)new VerifyDeserializedObjectCommandContextCloseListener(new DeserializedObject(this, valueFields.getCachedValue(), bytes, (VariableInstanceEntity)valueFields)));
            }
            return deserializedObject;
        }
        return null;
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        byte[] bytes = this.serialize(value, valueFields);
        valueFields.setCachedValue(value);
        super.setValue(bytes, valueFields);
        if (this.trackDeserializedObjects && valueFields instanceof VariableInstanceEntity) {
            Context.getCommandContext().addCloseListener((CommandContextCloseListener)new VerifyDeserializedObjectCommandContextCloseListener(new DeserializedObject(this, valueFields.getCachedValue(), bytes, (VariableInstanceEntity)valueFields)));
        }
    }

    public byte[] serialize(Object value, ValueFields valueFields) {
        if (value == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = this.createObjectOutputStream(baos);
            oos.writeObject(value);
        }
        catch (Exception e) {
            throw new FlowableException("Couldn't serialize value '" + value + "' in variable '" + valueFields.getName() + "'", (Throwable)e);
        }
        finally {
            IoUtil.closeSilently((OutputStream)oos);
        }
        return baos.toByteArray();
    }

    public Object deserialize(byte[] bytes, ValueFields valueFields) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try {
            Object deserializedObject;
            ObjectInputStream ois = this.createObjectInputStream(bais);
            Object object = deserializedObject = ois.readObject();
            return object;
        }
        catch (Exception e) {
            throw new FlowableException("Couldn't deserialize object in variable '" + valueFields.getName() + "'", (Throwable)e);
        }
        finally {
            IoUtil.closeSilently((InputStream)bais);
        }
    }

    @Override
    public boolean isAbleToStore(Object value) {
        return value instanceof Serializable;
    }

    protected ObjectInputStream createObjectInputStream(InputStream is) throws IOException {
        return new ObjectInputStream(is){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                return ReflectUtil.loadClass((String)desc.getName());
            }
        };
    }

    protected ObjectOutputStream createObjectOutputStream(OutputStream os) throws IOException {
        return new ObjectOutputStream(os);
    }
}

