/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.common.engine.impl.cfg.IdGenerator;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.impl.ActivityInstanceQueryImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.HistoryManager;
import org.flowable.engine.impl.persistence.entity.AbstractProcessEngineEntityManager;
import org.flowable.engine.impl.persistence.entity.ActivityInstanceEntity;
import org.flowable.engine.impl.persistence.entity.ActivityInstanceEntityManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.engine.impl.persistence.entity.data.ActivityInstanceDataManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.runtime.ActivityInstance;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class ActivityInstanceEntityManagerImpl
extends AbstractProcessEngineEntityManager<ActivityInstanceEntity, ActivityInstanceDataManager>
implements ActivityInstanceEntityManager {
    protected static final String NO_ACTIVITY_ID_PREFIX = "_flow_";
    protected static final String NO_ACTIVITY_ID_SEPARATOR = "__";
    protected final boolean usePrefixId;

    public ActivityInstanceEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, ActivityInstanceDataManager activityInstanceDataManager) {
        super(processEngineConfiguration, activityInstanceDataManager);
        this.usePrefixId = processEngineConfiguration.isUsePrefixId();
    }

    protected List<ActivityInstanceEntity> findUnfinishedActivityInstancesByExecutionAndActivityId(String executionId, String activityId) {
        return ((ActivityInstanceDataManager)this.dataManager).findUnfinishedActivityInstancesByExecutionAndActivityId(executionId, activityId);
    }

    @Override
    public List<ActivityInstanceEntity> findActivityInstancesByExecutionAndActivityId(String executionId, String activityId) {
        return ((ActivityInstanceDataManager)this.dataManager).findActivityInstancesByExecutionIdAndActivityId(executionId, activityId);
    }

    @Override
    public void deleteActivityInstancesByProcessInstanceId(String processInstanceId) {
        ((ActivityInstanceDataManager)this.dataManager).deleteActivityInstancesByProcessInstanceId(processInstanceId);
    }

    @Override
    public long findActivityInstanceCountByQueryCriteria(ActivityInstanceQueryImpl historicActivityInstanceQuery) {
        return ((ActivityInstanceDataManager)this.dataManager).findActivityInstanceCountByQueryCriteria(historicActivityInstanceQuery);
    }

    @Override
    public List<ActivityInstance> findActivityInstancesByQueryCriteria(ActivityInstanceQueryImpl historicActivityInstanceQuery) {
        return ((ActivityInstanceDataManager)this.dataManager).findActivityInstancesByQueryCriteria(historicActivityInstanceQuery);
    }

    @Override
    public List<ActivityInstance> findActivityInstancesByNativeQuery(Map<String, Object> parameterMap) {
        return ((ActivityInstanceDataManager)this.dataManager).findActivityInstancesByNativeQuery(parameterMap);
    }

    @Override
    public long findActivityInstanceCountByNativeQuery(Map<String, Object> parameterMap) {
        return ((ActivityInstanceDataManager)this.dataManager).findActivityInstanceCountByNativeQuery(parameterMap);
    }

    @Override
    public void recordActivityStart(ExecutionEntity executionEntity) {
        ActivityInstance activityInstance = this.recordRuntimeActivityStart(executionEntity);
        if (activityInstance != null) {
            this.getHistoryManager().recordActivityStart(activityInstance);
        }
    }

    @Override
    public void recordActivityEnd(ExecutionEntity executionEntity, String deleteReason) {
        ActivityInstance activityInstance = this.recordActivityInstanceEnd(executionEntity, deleteReason);
        if (activityInstance == null) {
            this.getHistoryManager().recordActivityEnd(executionEntity, deleteReason, this.getClock().getCurrentTime());
        } else {
            this.getHistoryManager().recordActivityEnd(activityInstance);
        }
    }

    @Override
    public void recordSequenceFlowTaken(ExecutionEntity executionEntity) {
        ActivityInstanceEntity activityInstance = this.createActivityInstanceEntity(executionEntity);
        activityInstance.setDurationInMillis(0L);
        activityInstance.setEndTime(activityInstance.getStartTime());
        this.getHistoryManager().createHistoricActivityInstance(activityInstance);
    }

    @Override
    public void recordSubProcessInstanceStart(ExecutionEntity parentExecution, ExecutionEntity subProcessInstance) {
        ActivityInstanceEntity activityInstance = this.findUnfinishedActivityInstance(parentExecution);
        if (activityInstance != null) {
            activityInstance.setCalledProcessInstanceId(subProcessInstance.getProcessInstanceId());
            this.getHistoryManager().updateHistoricActivityInstance(activityInstance);
        }
        this.getHistoryManager().recordProcessInstanceStart(subProcessInstance);
    }

    @Override
    public void recordTaskCreated(TaskEntity task, ExecutionEntity execution) {
        this.recordActivityTaskCreated(task, execution);
        this.getHistoryManager().recordTaskCreated(task, execution);
    }

    protected void recordActivityTaskCreated(TaskEntity task, ExecutionEntity execution) {
        ActivityInstanceEntity activityInstance;
        if (execution != null && (activityInstance = this.findUnfinishedActivityInstance(execution)) != null) {
            activityInstance.setTaskId(task.getId());
            this.getHistoryManager().updateHistoricActivityInstance(activityInstance);
        }
    }

    @Override
    public void recordTaskInfoChange(TaskEntity taskEntity, Date changeTime) {
        ActivityInstanceEntity activityInstanceEntity = this.recordActivityTaskInfoChange(taskEntity);
        this.getHistoryManager().recordTaskInfoChange(taskEntity, activityInstanceEntity != null ? activityInstanceEntity.getId() : null, changeTime);
    }

    @Override
    public void syncUserTaskExecution(ExecutionEntity executionEntity, FlowElement newFlowElement, String oldActivityId, TaskEntity task) {
        this.syncUserTaskExecutionActivityInstance(executionEntity, oldActivityId, newFlowElement);
        this.getHistoryManager().updateActivity(executionEntity, oldActivityId, newFlowElement, task, this.getClock().getCurrentTime());
    }

    @Override
    public void updateActivityInstancesProcessDefinitionId(String newProcessDefinitionId, String processInstanceId) {
        ActivityInstanceQueryImpl activityQuery = new ActivityInstanceQueryImpl();
        activityQuery.processInstanceId(processInstanceId);
        List<ActivityInstance> activities = this.findActivityInstancesByQueryCriteria(activityQuery);
        if (activities != null) {
            for (ActivityInstance activityInstance : activities) {
                ActivityInstanceEntity activityEntity = (ActivityInstanceEntity)activityInstance;
                activityEntity.setProcessDefinitionId(newProcessDefinitionId);
                this.update(activityEntity);
            }
        }
    }

    protected void syncUserTaskExecutionActivityInstance(ExecutionEntity childExecution, String oldActivityId, FlowElement newFlowElement) {
        ActivityInstanceEntityManager activityInstanceEntityManager = CommandContextUtil.getActivityInstanceEntityManager();
        List<ActivityInstanceEntity> activityInstances = activityInstanceEntityManager.findActivityInstancesByExecutionAndActivityId(childExecution.getId(), oldActivityId);
        for (ActivityInstanceEntity activityInstance : activityInstances) {
            activityInstance.setProcessDefinitionId(childExecution.getProcessDefinitionId());
            activityInstance.setActivityId(childExecution.getActivityId());
            activityInstance.setActivityName(newFlowElement.getName());
        }
    }

    protected ActivityInstanceEntity recordActivityTaskInfoChange(TaskEntity taskEntity) {
        ActivityInstanceEntity activityInstance = null;
        ExecutionEntity executionEntity = (ExecutionEntity)this.getExecutionEntityManager().findById(taskEntity.getExecutionId());
        if (executionEntity != null && !Objects.equals(this.getOriginalAssignee(taskEntity), taskEntity.getAssignee())) {
            HistoricActivityInstanceEntity historicActivityInstance;
            activityInstance = this.findUnfinishedActivityInstance(executionEntity);
            if (activityInstance == null && (historicActivityInstance = this.getHistoryManager().findHistoricActivityInstance(executionEntity, true)) != null) {
                activityInstance = this.createActivityInstance(historicActivityInstance);
            }
            if (activityInstance != null) {
                activityInstance.setAssignee(taskEntity.getAssignee());
                this.getHistoryManager().updateHistoricActivityInstance(activityInstance);
            }
        }
        return activityInstance;
    }

    protected Object getOriginalAssignee(TaskEntity taskEntity) {
        if (taskEntity.getOriginalPersistentState() != null) {
            return ((Map)taskEntity.getOriginalPersistentState()).get("assignee");
        }
        return null;
    }

    protected ActivityInstance recordRuntimeActivityStart(ExecutionEntity executionEntity) {
        ActivityInstanceEntity activityInstance = null;
        if (executionEntity.getActivityId() != null && executionEntity.getCurrentFlowElement() != null && (activityInstance = this.findUnfinishedActivityInstance(executionEntity)) == null) {
            return this.createActivityInstance(executionEntity);
        }
        return null;
    }

    protected ActivityInstance createActivityInstance(ExecutionEntity executionEntity) {
        ActivityInstanceEntity activityInstance = null;
        if (executionEntity.getActivityId() != null && executionEntity.getCurrentFlowElement() != null) {
            activityInstance = this.getActivityInstanceFromCache(executionEntity.getId(), executionEntity.getActivityId(), true);
            activityInstance = activityInstance == null ? this.createActivityInstanceEntity(executionEntity) : null;
        }
        return activityInstance;
    }

    protected ActivityInstance recordActivityInstanceEnd(ExecutionEntity executionEntity, String deleteReason) {
        ActivityInstanceEntity activityInstance = this.findUnfinishedActivityInstance(executionEntity);
        if (activityInstance != null) {
            activityInstance.markEnded(deleteReason);
        } else {
            HistoricActivityInstanceEntity historicActivityInstance = this.getHistoryManager().findHistoricActivityInstance(executionEntity, true);
            if (historicActivityInstance != null) {
                activityInstance = this.createActivityInstance(historicActivityInstance);
                activityInstance.markEnded(deleteReason);
            }
        }
        return activityInstance;
    }

    @Override
    public ActivityInstanceEntity findUnfinishedActivityInstance(ExecutionEntity execution) {
        String activityId = this.getActivityIdForExecution(execution);
        if (activityId != null) {
            String executionId = execution.getId();
            ActivityInstanceEntity activityInstanceFromCache = this.getActivityInstanceFromCache(executionId, activityId, true);
            if (activityInstanceFromCache != null) {
                return activityInstanceFromCache;
            }
            if (!execution.isInserted() && !execution.isProcessInstanceType()) {
                List<ActivityInstanceEntity> activityInstances = this.findUnfinishedActivityInstancesByExecutionAndActivityId(executionId, activityId);
                ActivityInstanceEntity activityFromCache = this.getActivityInstanceFromCache(executionId, activityId, false);
                if (activityFromCache != null && activityFromCache.getEndTime() != null) {
                    activityInstances.remove(activityFromCache);
                }
                if (activityInstances.size() > 0) {
                    return activityInstances.get(0);
                }
            }
        }
        return null;
    }

    protected ActivityInstanceEntity createActivityInstanceEntity(ExecutionEntity execution) {
        IdGenerator idGenerator = ((ProcessEngineConfigurationImpl)this.engineConfiguration).getIdGenerator();
        String processDefinitionId = execution.getProcessDefinitionId();
        String processInstanceId = execution.getProcessInstanceId();
        ActivityInstanceEntity activityInstanceEntity = (ActivityInstanceEntity)this.create();
        if (this.usePrefixId) {
            activityInstanceEntity.setId(activityInstanceEntity.getIdPrefix() + idGenerator.getNextId());
        } else {
            activityInstanceEntity.setId(idGenerator.getNextId());
        }
        activityInstanceEntity.setProcessDefinitionId(processDefinitionId);
        activityInstanceEntity.setProcessInstanceId(processInstanceId);
        activityInstanceEntity.setExecutionId(execution.getId());
        if (execution.getActivityId() != null) {
            activityInstanceEntity.setActivityId(execution.getActivityId());
        } else if (execution.getCurrentFlowElement() instanceof SequenceFlow) {
            SequenceFlow currentFlowElement = (SequenceFlow)execution.getCurrentFlowElement();
            activityInstanceEntity.setActivityId(this.getArtificialSequenceFlowId(currentFlowElement));
        }
        if (execution.getCurrentFlowElement() != null) {
            activityInstanceEntity.setActivityName(execution.getCurrentFlowElement().getName());
            activityInstanceEntity.setActivityType(this.parseActivityType(execution.getCurrentFlowElement()));
        }
        Date now = this.getClock().getCurrentTime();
        activityInstanceEntity.setStartTime(now);
        if (execution.getTenantId() != null) {
            activityInstanceEntity.setTenantId(execution.getTenantId());
        }
        this.insert(activityInstanceEntity);
        return activityInstanceEntity;
    }

    protected ActivityInstanceEntity getActivityInstanceFromCache(String executionId, String activityId, boolean endTimeMustBeNull) {
        List cachedActivityInstances = CommandContextUtil.getEntityCache().findInCache(ActivityInstanceEntity.class);
        for (ActivityInstanceEntity cachedActivityInstance : cachedActivityInstances) {
            if (activityId == null || !activityId.equals(cachedActivityInstance.getActivityId()) || endTimeMustBeNull && cachedActivityInstance.getEndTime() != null || !executionId.equals(cachedActivityInstance.getExecutionId())) continue;
            return cachedActivityInstance;
        }
        return null;
    }

    protected String parseActivityType(FlowElement element) {
        String elementType = element.getClass().getSimpleName();
        elementType = elementType.substring(0, 1).toLowerCase() + elementType.substring(1);
        return elementType;
    }

    protected String getActivityIdForExecution(ExecutionEntity execution) {
        String activityId = null;
        if (execution.getCurrentFlowElement() instanceof FlowNode) {
            activityId = execution.getCurrentFlowElement().getId();
        } else if (execution.getCurrentFlowElement() instanceof SequenceFlow && execution.getCurrentFlowableListener() == null) {
            activityId = ((SequenceFlow)execution.getCurrentFlowElement()).getSourceFlowElement().getId();
        }
        return activityId;
    }

    protected ActivityInstanceEntity createActivityInstance(HistoricActivityInstance historicActivityInstance) {
        ActivityInstanceEntity activityInstanceEntity = (ActivityInstanceEntity)this.create();
        activityInstanceEntity.setId(historicActivityInstance.getId());
        activityInstanceEntity.setProcessDefinitionId(historicActivityInstance.getProcessDefinitionId());
        activityInstanceEntity.setProcessInstanceId(historicActivityInstance.getProcessInstanceId());
        activityInstanceEntity.setCalledProcessInstanceId(historicActivityInstance.getCalledProcessInstanceId());
        activityInstanceEntity.setExecutionId(historicActivityInstance.getExecutionId());
        activityInstanceEntity.setTaskId(historicActivityInstance.getTaskId());
        activityInstanceEntity.setActivityId(historicActivityInstance.getActivityId());
        activityInstanceEntity.setActivityName(historicActivityInstance.getActivityName());
        activityInstanceEntity.setActivityType(historicActivityInstance.getActivityType());
        activityInstanceEntity.setAssignee(historicActivityInstance.getAssignee());
        activityInstanceEntity.setStartTime(historicActivityInstance.getStartTime());
        activityInstanceEntity.setEndTime(historicActivityInstance.getEndTime());
        activityInstanceEntity.setDeleteReason(historicActivityInstance.getDeleteReason());
        activityInstanceEntity.setDurationInMillis(historicActivityInstance.getDurationInMillis());
        activityInstanceEntity.setTenantId(historicActivityInstance.getTenantId());
        this.insert(activityInstanceEntity);
        return activityInstanceEntity;
    }

    protected String getArtificialSequenceFlowId(SequenceFlow sequenceFlow) {
        return NO_ACTIVITY_ID_PREFIX + sequenceFlow.getSourceRef() + NO_ACTIVITY_ID_SEPARATOR + sequenceFlow.getTargetRef();
    }

    protected HistoryManager getHistoryManager() {
        return ((ProcessEngineConfigurationImpl)this.engineConfiguration).getHistoryManager();
    }

    protected ExecutionEntityManager getExecutionEntityManager() {
        return ((ProcessEngineConfigurationImpl)this.engineConfiguration).getExecutionEntityManager();
    }
}

