/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.types;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.HasVariableServiceConfiguration;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandContextCloseListener;
import org.flowable.common.engine.impl.util.IoUtil;
import org.flowable.common.engine.impl.util.ReflectUtil;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.flowable.variable.service.impl.types.ByteArrayType;
import org.flowable.variable.service.impl.types.MutableVariableType;
import org.flowable.variable.service.impl.types.TraceableObject;
import org.flowable.variable.service.impl.types.TraceableVariablesCommandContextCloseListener;

public class SerializableType
extends ByteArrayType
implements MutableVariableType<Object, byte[]> {
    public static final String TYPE_NAME = "serializable";
    protected boolean trackDeserializedObjects;

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    public SerializableType() {
    }

    public SerializableType(boolean trackDeserializedObjects) {
        this.trackDeserializedObjects = trackDeserializedObjects;
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        Object cachedObject = valueFields.getCachedValue();
        if (cachedObject != null) {
            return cachedObject;
        }
        byte[] bytes = (byte[])super.getValue(valueFields);
        if (bytes != null) {
            Object deserializedObject = this.deserialize(bytes, valueFields);
            valueFields.setCachedValue(deserializedObject);
            this.traceValue(valueFields.getCachedValue(), bytes, valueFields);
            return deserializedObject;
        }
        return null;
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        byte[] bytes = this.serialize(value, valueFields);
        valueFields.setCachedValue(value);
        super.setValue(bytes, valueFields);
        this.traceValue(valueFields.getCachedValue(), bytes, valueFields);
    }

    protected void traceValue(Object value, byte[] valueBytes, ValueFields valueFields) {
        VariableServiceConfiguration variableServiceConfiguration;
        CommandContext commandContext;
        if (this.trackDeserializedObjects && valueFields instanceof VariableInstanceEntity && (commandContext = Context.getCommandContext()) != null && (variableServiceConfiguration = this.getVariableServiceConfiguration(valueFields)) != null) {
            commandContext.addCloseListener((CommandContextCloseListener)new TraceableVariablesCommandContextCloseListener(new TraceableObject<Object, byte[]>(this, value, valueBytes, (VariableInstanceEntity)valueFields)));
        }
    }

    @Override
    public boolean updateValueIfChanged(Object tracedObject, byte[] originalBytes, VariableInstanceEntity variableInstanceEntity) {
        Object originalObject;
        byte[] refreshedOriginalBytes;
        byte[] bytes = this.serialize(tracedObject, (ValueFields)variableInstanceEntity);
        boolean valueChanged = false;
        if (!Arrays.equals(originalBytes, bytes) && !Arrays.equals(refreshedOriginalBytes = this.serialize(originalObject = this.deserialize(originalBytes, (ValueFields)variableInstanceEntity), (ValueFields)variableInstanceEntity), bytes)) {
            variableInstanceEntity.setBytes(bytes);
            valueChanged = true;
        }
        return valueChanged;
    }

    public byte[] serialize(Object value, ValueFields valueFields) {
        if (value == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = this.createObjectOutputStream(baos);
            oos.writeObject(value);
        }
        catch (Exception e) {
            throw new FlowableException("Couldn't serialize value '" + value + "' in variable '" + valueFields.getName() + "'", (Throwable)e);
        }
        finally {
            IoUtil.closeSilently((OutputStream)oos);
        }
        return baos.toByteArray();
    }

    public Object deserialize(byte[] bytes, ValueFields valueFields) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try {
            Object deserializedObject;
            ObjectInputStream ois = this.createObjectInputStream(bais);
            Object object = deserializedObject = ois.readObject();
            return object;
        }
        catch (Exception e) {
            throw new FlowableException("Couldn't deserialize object in variable '" + valueFields.getName() + "'", (Throwable)e);
        }
        finally {
            IoUtil.closeSilently((InputStream)bais);
        }
    }

    protected VariableServiceConfiguration getVariableServiceConfiguration(ValueFields valueFields) {
        String engineType = this.getEngineType(valueFields.getScopeType());
        Map engineConfigurationMap = Context.getCommandContext().getEngineConfigurations();
        AbstractEngineConfiguration engineConfiguration = (AbstractEngineConfiguration)engineConfigurationMap.get(engineType);
        if (engineConfiguration == null) {
            for (AbstractEngineConfiguration possibleEngineConfiguration : engineConfigurationMap.values()) {
                if (!(possibleEngineConfiguration instanceof HasVariableServiceConfiguration)) continue;
                engineConfiguration = possibleEngineConfiguration;
            }
        }
        if (engineConfiguration == null) {
            return null;
        }
        return (VariableServiceConfiguration)((Object)engineConfiguration.getServiceConfigurations().get("cfg.variableService"));
    }

    protected String getEngineType(String scopeType) {
        if (StringUtils.isNotEmpty((CharSequence)scopeType)) {
            return scopeType;
        }
        return "bpmn";
    }

    @Override
    public boolean isAbleToStore(Object value) {
        return value instanceof Serializable;
    }

    protected ObjectInputStream createObjectInputStream(InputStream is) throws IOException {
        return new ObjectInputStream(is){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                return ReflectUtil.loadClass((String)desc.getName());
            }
        };
    }

    protected ObjectOutputStream createObjectOutputStream(OutputStream os) throws IOException {
        return new ObjectOutputStream(os);
    }
}

