/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ProcessorResult;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.asyncqueue.AsyncQueueEnabledTransport;
import org.glassfish.grizzly.asyncqueue.AsyncQueueReader;
import org.glassfish.grizzly.asyncqueue.AsyncQueueWriter;
import org.glassfish.grizzly.asyncqueue.PushBackHandler;
import org.glassfish.grizzly.nio.transport.DefaultStreamReader;
import org.glassfish.grizzly.nio.transport.DefaultStreamWriter;
import org.glassfish.grizzly.streams.StreamReader;
import org.glassfish.grizzly.streams.StreamWriter;

public class StandaloneProcessor
implements Processor {
    public static final StandaloneProcessor INSTANCE = new StandaloneProcessor();

    public ProcessorResult process(Context context) {
        IOEvent iOEvent = context.getIoEvent();
        if (iOEvent == IOEvent.READ) {
            Connection connection = context.getConnection();
            AsyncQueueReader reader = ((AsyncQueueEnabledTransport)((Object)connection.getTransport())).getAsyncQueueIO().getReader();
            return reader.processAsync(context).toProcessorResult();
        }
        if (iOEvent == IOEvent.WRITE) {
            Connection connection = context.getConnection();
            AsyncQueueWriter writer = ((AsyncQueueEnabledTransport)((Object)connection.getTransport())).getAsyncQueueIO().getWriter();
            return writer.processAsync(context).toProcessorResult();
        }
        throw new IllegalStateException("Unexpected IOEvent=" + (Object)((Object)iOEvent));
    }

    @Override
    public boolean isInterested(IOEvent ioEvent) {
        return ioEvent == IOEvent.READ || ioEvent == IOEvent.WRITE;
    }

    @Override
    public void setInterested(IOEvent ioEvent, boolean isInterested) {
    }

    public Context obtainContext(Connection connection) {
        Context context = Context.create(connection);
        context.setProcessor(this);
        return context;
    }

    public StreamReader getStreamReader(Connection connection) {
        return new DefaultStreamReader(connection);
    }

    public StreamWriter getStreamWriter(Connection connection) {
        return new DefaultStreamWriter(connection);
    }

    public void read(Connection connection, CompletionHandler completionHandler) {
        Transport transport = connection.getTransport();
        transport.getReader(connection).read(connection, null, completionHandler);
    }

    public void write(Connection connection, Object dstAddress, Object message, CompletionHandler completionHandler) {
        this.write(connection, dstAddress, message, completionHandler, (PushBackHandler)null);
    }

    @Deprecated
    public void write(Connection connection, Object dstAddress, Object message, CompletionHandler completionHandler, PushBackHandler pushBackHandler) {
        Transport transport = connection.getTransport();
        transport.getWriter(connection).write(connection, dstAddress, (Buffer)message, completionHandler, pushBackHandler);
    }
}

