/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.ajp;

import java.io.IOException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.utils.NullaryFunction;

public class AjpMessageFilter
extends BaseFilter {
    private final Attribute<ParsingState> parsingStateAttribute = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(AjpMessageFilter.class + ".parsingStateAttribute", (NullaryFunction)new NullaryFunction<ParsingState>(){

        public ParsingState evaluate() {
            return new ParsingState();
        }
    });

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        int start;
        Buffer buffer = (Buffer)ctx.getMessage();
        Connection connection = ctx.getConnection();
        ParsingState parsingState = (ParsingState)this.parsingStateAttribute.get((AttributeStorage)connection);
        if (!parsingState.isHeaderParsed) {
            if (buffer.remaining() < 4) {
                return ctx.getStopAction((Object)buffer);
            }
            start = buffer.position();
            short mark = buffer.getShort(start);
            if (mark != 4660 && mark != 16706) {
                throw new IllegalStateException("Unexpected mark=" + mark);
            }
            parsingState.length = buffer.getShort(start + 2);
            parsingState.isHeaderParsed = true;
            if (parsingState.length + 4 > 8192) {
                throw new IllegalStateException("The message is too large. " + (parsingState.length + 4) + ">" + 8192);
            }
        }
        if (buffer.remaining() < 4 + parsingState.length) {
            return ctx.getStopAction((Object)buffer);
        }
        start = buffer.position();
        Buffer remainder = buffer.split(start + parsingState.length + 4);
        buffer.position(start + 4);
        parsingState.parsed();
        return ctx.getInvokeAction(remainder.hasRemaining() ? remainder : null);
    }

    static final class ParsingState {
        boolean isHeaderParsed;
        int length;

        ParsingState() {
        }

        void parsed() {
            this.isHeaderParsed = false;
            this.length = 0;
        }

        void reset() {
            this.isHeaderParsed = false;
            this.length = 0;
        }
    }
}

