/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.Body;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.Param;
import com.ning.http.client.Request;
import com.ning.http.client.listener.TransferCompletionHandler;
import com.ning.http.client.multipart.MultipartBody;
import com.ning.http.client.multipart.MultipartUtils;
import com.ning.http.client.multipart.Part;
import com.ning.http.client.providers.grizzly.FeedableBodyGenerator;
import com.ning.http.client.providers.grizzly.HttpTransactionContext;
import com.ning.http.client.providers.grizzly.PayloadGenerator;
import com.ning.http.util.MiscUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.FileTransfer;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.utils.Charsets;

final class PayloadGenFactory {
    private static final PayloadGenerator[] HANDLERS = new PayloadGenerator[]{new StringPayloadGenerator(), new ByteArrayPayloadGenerator(), new ParamsPayloadGenerator(), new StreamDataPayloadGenerator(), new PartsPayloadGenerator(), new FilePayloadGenerator(), new BodyGeneratorAdapter()};

    PayloadGenFactory() {
    }

    public static PayloadGenerator wrapWithExpect(PayloadGenerator generator) {
        return new ExpectWrapper(generator);
    }

    public static PayloadGenerator getPayloadGenerator(Request request) {
        for (PayloadGenerator h : HANDLERS) {
            if (!h.handlesPayloadType(request)) continue;
            return h;
        }
        return null;
    }

    private static final class BodyGeneratorAdapter
    extends PayloadGenerator {
        private BodyGeneratorAdapter() {
        }

        @Override
        public boolean handlesPayloadType(Request request) {
            return request.getBodyGenerator() != null;
        }

        @Override
        public boolean generate(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            BodyGenerator generator = request.getBodyGenerator();
            Body bodyLocal = generator.createBody();
            long len = bodyLocal.getContentLength();
            if (len >= 0L) {
                requestPacket.setContentLengthLong(len);
            } else {
                requestPacket.setChunked(true);
            }
            MemoryManager mm = ctx.getMemoryManager();
            boolean last = false;
            while (!last) {
                Buffer buffer = mm.allocate(MAX_CHUNK_SIZE);
                buffer.allowBufferDispose(true);
                long readBytes = bodyLocal.read(buffer.toByteBuffer());
                if (readBytes > 0L) {
                    buffer.position((int)readBytes);
                    buffer.trim();
                } else {
                    buffer.dispose();
                    if (readBytes < 0L) {
                        last = true;
                        buffer = Buffers.EMPTY_BUFFER;
                    } else {
                        if (generator instanceof FeedableBodyGenerator) {
                            ((FeedableBodyGenerator)generator).initializeAsynchronousTransfer(ctx, requestPacket);
                            return false;
                        }
                        throw new IllegalStateException("BodyGenerator unexpectedly returned 0 bytes available");
                    }
                }
                HttpContent content = requestPacket.httpContentBuilder().content(buffer).last(last).build();
                ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            }
            return true;
        }
    }

    private static final class FilePayloadGenerator
    extends PayloadGenerator {
        private static final boolean SEND_FILE_SUPPORT = false;

        private FilePayloadGenerator() {
        }

        @Override
        public boolean handlesPayloadType(Request request) {
            return request.getFile() != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean generate(FilterChainContext ctx, Request request, final HttpRequestPacket requestPacket) throws IOException {
            File f = request.getFile();
            requestPacket.setContentLengthLong(f.length());
            final HttpTransactionContext context = HttpTransactionContext.currentTransaction((HttpHeader)requestPacket);
            if (!SEND_FILE_SUPPORT || requestPacket.isSecure()) {
                FileInputStream fis = new FileInputStream(request.getFile());
                MemoryManager mm = ctx.getMemoryManager();
                AtomicInteger written = new AtomicInteger();
                boolean last = false;
                try {
                    byte[] buf = new byte[MAX_CHUNK_SIZE];
                    while (!last) {
                        Buffer b = null;
                        int read = fis.read(buf);
                        if (read < 0) {
                            last = true;
                            b = Buffers.EMPTY_BUFFER;
                        }
                        if (b != Buffers.EMPTY_BUFFER) {
                            written.addAndGet(read);
                            b = Buffers.wrap((MemoryManager)mm, (byte[])buf, (int)0, (int)read);
                        }
                        HttpContent content = requestPacket.httpContentBuilder().content(b).last(last).build();
                        ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
                    }
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            ctx.write((Object)requestPacket, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            ctx.write((Object)new FileTransfer(f), (CompletionHandler)new EmptyCompletionHandler<WriteResult>(){

                public void updated(WriteResult result) {
                    AsyncHandler ah = context.getAsyncHandler();
                    if (ah instanceof TransferCompletionHandler) {
                        long written = result.getWrittenSize();
                        context.totalBodyWritten += written;
                        long total = context.totalBodyWritten;
                        ((TransferCompletionHandler)ah).onContentWriteProgress(written, total, requestPacket.getContentLength());
                    }
                }
            });
            return true;
        }

        @Override
        protected long getContentLength(Request request) {
            return request.getContentLength() >= 0L ? request.getContentLength() : request.getFile().length();
        }
    }

    private static final class PartsPayloadGenerator
    extends PayloadGenerator {
        private PartsPayloadGenerator() {
        }

        @Override
        public boolean handlesPayloadType(Request request) {
            return MiscUtils.isNonEmpty(request.getParts());
        }

        @Override
        public boolean generate(final FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            List<Part> parts = request.getParts();
            final MultipartBody multipartBody = MultipartUtils.newMultipartBody(parts, request.getHeaders());
            long contentLength = multipartBody.getContentLength();
            String contentType = multipartBody.getContentType();
            requestPacket.setContentLengthLong(contentLength);
            requestPacket.setContentType(contentType);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("REQUEST(modified): contentLength={}, contentType={}", new Object[]{requestPacket.getContentLength(), requestPacket.getContentType()});
            }
            FeedableBodyGenerator generator = new FeedableBodyGenerator(){

                @Override
                public Body createBody() throws IOException {
                    return multipartBody;
                }
            };
            generator.setFeeder(new FeedableBodyGenerator.BaseFeeder(generator){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void flush() throws IOException {
                    Body bodyLocal = this.feedableBodyGenerator.createBody();
                    try {
                        MemoryManager mm = ctx.getMemoryManager();
                        boolean last = false;
                        while (!last) {
                            Buffer buffer = mm.allocate(PayloadGenerator.MAX_CHUNK_SIZE);
                            buffer.allowBufferDispose(true);
                            long readBytes = bodyLocal.read(buffer.toByteBuffer());
                            if (readBytes > 0L) {
                                buffer.position((int)readBytes);
                                buffer.trim();
                            } else {
                                buffer.dispose();
                                if (readBytes < 0L) {
                                    last = true;
                                    buffer = Buffers.EMPTY_BUFFER;
                                } else {
                                    throw new IllegalStateException("MultipartBody unexpectedly returned 0 bytes available");
                                }
                            }
                            this.feed(buffer, last);
                        }
                    }
                    finally {
                        if (bodyLocal != null) {
                            try {
                                bodyLocal.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            });
            generator.initializeAsynchronousTransfer(ctx, requestPacket);
            return false;
        }
    }

    private static final class StreamDataPayloadGenerator
    extends PayloadGenerator {
        private StreamDataPayloadGenerator() {
        }

        @Override
        public boolean handlesPayloadType(Request request) {
            return request.getStreamData() != null;
        }

        @Override
        public boolean generate(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            int read;
            InputStream in;
            byte[] b;
            Buffer buffer;
            MemoryManager mm;
            block6: {
                mm = ctx.getMemoryManager();
                buffer = mm.allocate(512);
                b = new byte[512];
                in = request.getStreamData();
                try {
                    in.reset();
                }
                catch (IOException ioe) {
                    if (!LOGGER.isDebugEnabled()) break block6;
                    LOGGER.debug(ioe.toString(), (Throwable)ioe);
                }
            }
            if (in.markSupported()) {
                in.mark(0);
            }
            while ((read = in.read(b)) != -1) {
                if (read > buffer.remaining()) {
                    buffer = mm.reallocate(buffer, buffer.capacity() + 512);
                }
                buffer.put(b, 0, read);
            }
            buffer.trim();
            if (buffer.hasRemaining()) {
                HttpContent content = requestPacket.httpContentBuilder().content(buffer).last(true).build();
                buffer.allowBufferDispose(false);
                ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            }
            return true;
        }
    }

    private static final class ParamsPayloadGenerator
    extends PayloadGenerator {
        private ParamsPayloadGenerator() {
        }

        @Override
        public boolean handlesPayloadType(Request request) {
            return MiscUtils.isNonEmpty(request.getFormParams());
        }

        @Override
        public boolean generate(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            String charset;
            if (requestPacket.getContentType() == null) {
                requestPacket.setContentType("application/x-www-form-urlencoded");
            }
            if ((charset = request.getBodyEncoding()) == null) {
                charset = Charsets.ASCII_CHARSET.name();
            }
            if (MiscUtils.isNonEmpty(request.getFormParams())) {
                StringBuilder sb = new StringBuilder(128);
                for (Param param : request.getFormParams()) {
                    String name = URLEncoder.encode(param.getName(), charset);
                    String value = URLEncoder.encode(param.getValue(), charset);
                    sb.append(name).append('=').append(value).append('&');
                }
                sb.setLength(sb.length() - 1);
                byte[] data = sb.toString().getBytes(charset);
                MemoryManager mm = ctx.getMemoryManager();
                Buffer gBuffer = Buffers.wrap((MemoryManager)mm, (byte[])data);
                HttpContent content = requestPacket.httpContentBuilder().content(gBuffer).last(true).build();
                if (requestPacket.getContentLength() == -1L) {
                    requestPacket.setContentLengthLong((long)data.length);
                }
                ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            }
            return true;
        }
    }

    private static final class StringPayloadGenerator
    extends PayloadGenerator {
        private StringPayloadGenerator() {
        }

        @Override
        public boolean handlesPayloadType(Request request) {
            return request.getStringData() != null;
        }

        @Override
        public boolean generate(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            String charset = request.getBodyEncoding();
            if (charset == null) {
                charset = Charsets.ASCII_CHARSET.name();
            }
            byte[] data = request.getStringData().getBytes(charset);
            MemoryManager mm = ctx.getMemoryManager();
            Buffer gBuffer = Buffers.wrap((MemoryManager)mm, (byte[])data);
            if (requestPacket.getContentLength() == -1L) {
                requestPacket.setContentLengthLong((long)data.length);
            }
            HttpContent content = requestPacket.httpContentBuilder().content(gBuffer).last(true).build();
            ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            return true;
        }
    }

    private static final class ByteArrayPayloadGenerator
    extends PayloadGenerator {
        private ByteArrayPayloadGenerator() {
        }

        @Override
        public boolean handlesPayloadType(Request request) {
            return request.getByteData() != null;
        }

        @Override
        public boolean generate(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            MemoryManager mm = ctx.getMemoryManager();
            byte[] data = request.getByteData();
            Buffer gBuffer = Buffers.wrap((MemoryManager)mm, (byte[])data);
            if (requestPacket.getContentLength() == -1L) {
                requestPacket.setContentLengthLong((long)data.length);
            }
            HttpContent content = requestPacket.httpContentBuilder().content(gBuffer).last(true).build();
            ctx.write((Object)content, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            return true;
        }

        @Override
        protected long getContentLength(Request request) {
            return request.getContentLength() >= 0L ? request.getContentLength() : (long)request.getByteData().length;
        }
    }

    private static final class ExpectWrapper
    extends PayloadGenerator {
        final PayloadGenerator delegate;
        Request request;
        HttpRequestPacket requestPacket;

        private ExpectWrapper(PayloadGenerator delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean handlesPayloadType(Request request) {
            return this.delegate.handlesPayloadType(request);
        }

        @Override
        public boolean generate(FilterChainContext ctx, Request request, HttpRequestPacket requestPacket) throws IOException {
            this.request = request;
            this.requestPacket = requestPacket;
            long contentLength = this.delegate.getContentLength(request);
            if (contentLength != -1L) {
                requestPacket.setContentLengthLong(contentLength);
            }
            ctx.write((Object)requestPacket, !requestPacket.isCommitted() ? ctx.getTransportContext().getCompletionHandler() : null);
            return true;
        }

        @Override
        public void continueConfirmed(FilterChainContext ctx) throws IOException {
            this.delegate.generate(ctx, this.request, this.requestPacket);
        }
    }
}

